/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.AbstractFileUploadExecutor;

public class KeyStoreFileUploadExecutor
extends AbstractFileUploadExecutor {
    public KeyStoreFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServerException, IOException {
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        PrintWriter out = response.getWriter();
        response.setContentType("text/html; charset=utf-8");
        try {
            if (isMultipart) {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    String ksUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "keystores" + File.separator + uuid + File.separator;
                    File dirs = new File(ksUploadDir);
                    if (!dirs.exists()) {
                        dirs.mkdirs();
                    }
                    File uploadedFile = new File(ksUploadDir, this.getFileName(item.getName()));
                    item.write(uploadedFile);
                    Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
                    if (fileResourceMap == null) {
                        fileResourceMap = new TreeBidiMap();
                        this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
                    }
                    fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                    item.write(uploadedFile);
                    out.write("<script language=\"javascript\">top.getKeystoreUUID('" + uuid + "');" + "</script>");
                }
                out.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)"KeyStore file upload failed", (Throwable)e);
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('KeyStore file upload FAILED. Reason : " + e + "');" + "</script>");
        }
        finally {
            out.close();
        }
        return true;
    }
}

