/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.AnyFileUploadExecutor;
import org.wso2.wsas.transport.fileupload.FileUploadExecutor;

public class FileUploadExecutorManager {
    private static Log log = LogFactory.getLog((Class)FileUploadExecutorManager.class);
    private ConfigurationContext configurationContext;
    private Map executorMap = new HashMap();
    static /* synthetic */ Class class$org$apache$axis2$context$ConfigurationContext;

    public FileUploadExecutorManager(ConfigurationContext configurationContext) throws ServerException {
        this.configurationContext = configurationContext;
        this.executorMapFilter();
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServerException {
        String requestURI = request.getRequestURI();
        boolean executed = false;
        Iterator iterator = this.executorMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (requestURI.indexOf(key) < 0) continue;
            FileUploadExecutor obj = (FileUploadExecutor)this.executorMap.get(key);
            obj.execute(request, response);
            executed = true;
            break;
        }
        if (!executed) {
            Object obj = this.executorMap.get("*");
            if (obj == null) {
                log.warn((Object)"Reached 'All' section but Could not find the Implementation Class");
                return false;
            }
            AnyFileUploadExecutor executor = (AnyFileUploadExecutor)obj;
            executor.execute(request, response);
        }
        return true;
    }

    private void executorMapFilter() throws ServerException {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        OMElement documentElement = serverConfiguration.getDocumentElement();
        OMElement fileUploadConfigElement = documentElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "FileUploadConfig"));
        Iterator iterator = fileUploadConfigElement.getChildElements();
        while (iterator.hasNext()) {
            String msg;
            FileUploadExecutor object;
            OMElement mapppingElement = (OMElement)iterator.next();
            if (!mapppingElement.getLocalName().equalsIgnoreCase("Mapping")) continue;
            OMElement actionsElement = mapppingElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Actions"));
            if (actionsElement == null) {
                String msg2 = "The mandatory FileUploadConfig/Actions entry does not exist or is empty in the WSO2WSAS_HOME/conf/server.xml file. Please fix this error in the  server.xml file and restart.";
                log.error((Object)msg2);
                throw new ServerException(msg2);
            }
            Iterator actionElementIterator = actionsElement.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Action"));
            if (!actionElementIterator.hasNext()) {
                String msg3 = "A FileUploadConfig/Mapping entry in the WSO2WSAS_HOME/conf/server.xml should have at least on Action defined. Please fix this error in the server.xml file and restart.";
                log.error((Object)msg3);
                throw new ServerException(msg3);
            }
            OMElement classElement = mapppingElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Class"));
            if (classElement == null || classElement.getText() == null) {
                String msg4 = "The mandatory FileUploadConfig/Mapping/Class entry does not exist or is empty in the WSO2WSAS_HOME/conf/server.xml file. Please fix this error in the  server.xml file and restart.";
                log.error((Object)msg4);
                throw new ServerException(msg4);
            }
            String className = classElement.getText().trim();
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(class$org$apache$axis2$context$ConfigurationContext == null ? FileUploadExecutorManager.class$("org.apache.axis2.context.ConfigurationContext") : class$org$apache$axis2$context$ConfigurationContext);
                object = (FileUploadExecutor)constructor.newInstance(this.configurationContext);
            }
            catch (Exception e) {
                msg = "Error occurred while trying to instantiate the " + className + " class specified as a FileUploadConfig/Mapping/class element in " + "the WSO2WSAS_HOME/conf/server.xml file. Please fix this error in " + "the server.xml file and restart.";
                log.error((Object)msg, (Throwable)e);
                throw new ServerException(msg, (Throwable)e);
            }
            while (actionElementIterator.hasNext()) {
                OMElement actionElement = (OMElement)actionElementIterator.next();
                if (actionElement.getText() == null) {
                    msg = "A FileUploadConfig/Mapping/Actions/Action element in the WSO2WSAS_HOME/conf/server.xml file is empty. Please include the correct value in this file and restart.";
                    log.error((Object)msg);
                    throw new ServerException(msg);
                }
                this.executorMap.put(actionElement.getText().trim(), object);
            }
        }
    }
}

