/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.AbstractFileUploadExecutor;
import org.wso2.wsas.util.WsasUtils;

public class EJBInterfaceFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".jar", ".zip"};

    public EJBInterfaceFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServerException, IOException {
        PrintWriter out = response.getWriter();
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('You are not permitted to upload services to URL repository " + axis2Repo + "');" + "</script>");
            out.flush();
            return false;
        }
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        if (isMultipart) {
            try {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    String fileName;
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    this.checkServiceFileExtensionValidity(fileExtension, ALLOWED_FILE_EXTENSIONS);
                    String fileNameOnly = this.getFileName(fileName);
                    String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    String serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "services" + File.separator + uuid + File.separator;
                    File servicesDir = new File(serviceUploadDir);
                    servicesDir.mkdirs();
                    File uploadedFile = new File(servicesDir, fileNameOnly);
                    Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
                    if (fileResourceMap == null) {
                        fileResourceMap = new TreeBidiMap();
                        this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
                    }
                    fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                    item.write(uploadedFile);
                    out.write("<script language=\"javascript\">top.getEJBRemoteInterfaceClassListFromArchive('" + uuid + "');" + "</script>");
                }
                return true;
            }
            catch (Exception e) {
                log.error((Object)"File upload failed", (Throwable)e);
                out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('EJB remote and home interface upload FAILED. Reason : " + e.getMessage() + "');" + "</script>");
            }
        }
        return false;
    }
}

