/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.FileUploadExecutor;
import org.wso2.wsas.util.WsasUtils;

public abstract class AbstractFileUploadExecutor
implements FileUploadExecutor {
    protected static final Log log = LogFactory.getLog((Class)AbstractFileUploadExecutor.class);
    protected ConfigurationContext configurationContext;

    public AbstractFileUploadExecutor(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    protected void checkServiceFileExtensionValidity(String fileExtension, String[] allowedExtensions) throws Exception {
        boolean isExtensionValid = false;
        StringBuffer allowedExtensionsStr = new StringBuffer();
        for (int i = 0; i < allowedExtensions.length; ++i) {
            allowedExtensionsStr.append(allowedExtensions[i]).append(",");
            if (!fileExtension.endsWith(allowedExtensions[i])) continue;
            isExtensionValid = true;
            break;
        }
        if (!isExtensionValid) {
            throw new Exception(" Illegal file type. Allowed file extensions are " + allowedExtensionsStr);
        }
    }

    protected File uploadFile(HttpServletRequest request, String repoDir, HttpServletResponse response, String extension) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        File uploadedFile = null;
        if (isMultipart) {
            try {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    String fileName;
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    if (extension != null && !fileExtension.endsWith(extension)) {
                        throw new Exception(" Illegal file type. Only " + extension + " files can be uploaded");
                    }
                    String fileNameOnly = this.getFileName(fileName);
                    uploadedFile = new File(repoDir, fileNameOnly);
                    item.write(uploadedFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"File upload failed", (Throwable)e);
                response.getWriter().write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('File upload FAILED. " + e.getMessage() + "');" + "</script>");
            }
        }
        return uploadedFile;
    }

    protected String getFileName(String fileName) {
        String fileNameOnly = fileName.indexOf("\\") < 0 ? fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length()) : fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
        return fileNameOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeCommon(HttpServletRequest request, HttpServletResponse response, String extraStoreDirUUID) throws ServerException, IOException {
        if (extraStoreDirUUID == null || extraStoreDirUUID.equals("") && extraStoreDirUUID.length() == 0) {
            throw new ServerException("Specify extraStoreDirUUID");
        }
        extraStoreDirUUID = extraStoreDirUUID.trim();
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        PrintWriter out = response.getWriter();
        response.setContentType("text/html; charset=utf-8");
        try {
            if (isMultipart) {
                List items = this.parseRequest(servletRequestContext);
                boolean multiItems = false;
                if (items.size() > 1) {
                    multiItems = true;
                }
                ArrayList<String> uuidList = new ArrayList<String>();
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    uuidList.add(uuid);
                    String extraFileLocation = this.configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
                    File dirs = new File(extraFileLocation);
                    if (!dirs.exists()) {
                        dirs.mkdirs();
                    }
                    File uploadedFile = new File(extraFileLocation, this.getFileName(item.getName()));
                    String fileName = item.getName();
                    if ((fileName == null || fileName.length() == 0) && multiItems) continue;
                    item.write(uploadedFile);
                    Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
                    if (fileResourceMap == null) {
                        fileResourceMap = new TreeBidiMap();
                        this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
                    }
                    fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                }
                int size = uuidList.size();
                if (size == 1) {
                    out.write("<script language=\"javascript\">top." + extraStoreDirUUID + "('" + uuidList.get(0) + "');" + "</script>");
                } else {
                    String s = "var uObj = new Object();";
                    for (int i = 0; i < size; ++i) {
                        s = s + "uObj[" + i + "]=\"" + uuidList.get(i) + "\";\n";
                    }
                    out.write("<script language=\"javascript\">" + s + "top." + extraStoreDirUUID + "(uObj);" + "</script>");
                }
                out.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)"File upload FAILED", (Throwable)e);
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('File upload FAILED. File may be non-existent or invalid.');</script>");
        }
        finally {
            out.close();
        }
        return true;
    }

    protected List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }

    protected boolean uploadArtifacts(HttpServletRequest request, HttpServletResponse response, String uploadDirName, String[] extensions, String utilityString) throws IOException {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        PrintWriter out = response.getWriter();
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('You are not permitted to upload jars to URL repository " + axis2Repo + "');" + "</script>");
            out.flush();
            return false;
        }
        String tmpDir = (String)this.configurationContext.getProperty("WORK_DIR");
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        tmpDir = tmpDir + File.separator + "artifacts" + File.separator + uuid + File.separator;
        new File(tmpDir).mkdirs();
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        if (isMultipart) {
            try {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    File uploadedFile;
                    File servicesDir;
                    String fileName;
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    String fileNameOnly = this.getFileName(fileName);
                    String fieldName = item.getFieldName();
                    if (fieldName != null && fieldName.equals("jarResource")) {
                        if (!fileExtension.endsWith(".jar")) continue;
                        servicesDir = new File(tmpDir + File.separator + uploadDirName, "lib");
                        if (!servicesDir.exists()) {
                            servicesDir.mkdirs();
                        }
                        uploadedFile = new File(servicesDir, fileNameOnly);
                        item.write(uploadedFile);
                        continue;
                    }
                    servicesDir = new File(tmpDir, uploadDirName);
                    if (!servicesDir.exists()) {
                        servicesDir.mkdirs();
                    }
                    uploadedFile = new File(servicesDir, fileNameOnly);
                    item.write(uploadedFile);
                }
                String repo = this.configurationContext.getAxisConfiguration().getRepository().getPath();
                FileManipulator fm = new FileManipulator();
                String parent = repo + File.separator + uploadDirName;
                File mainDir = new File(tmpDir + File.separator + uploadDirName);
                File libDir = new File(mainDir, "lib");
                File[] resourceLibFile = fm.getMatchingFiles(libDir.getAbsolutePath(), null, "jar");
                for (int j = 0; j < resourceLibFile.length; ++j) {
                    File dst = new File(parent, "lib");
                    File src = resourceLibFile[j];
                    String[] files = libDir.list();
                    for (int i = 0; i < files.length; ++i) {
                        this.copyFile(src, new File(dst, files[i]));
                    }
                }
                for (int i = 0; i < extensions.length; ++i) {
                    File[] mainFiles = fm.getMatchingFiles(mainDir.getAbsolutePath(), null, extensions[i]);
                    for (int j = 0; j < mainFiles.length; ++j) {
                        File dst = new File(parent);
                        String[] files = mainDir.list();
                        for (int k = 0; k < files.length; ++k) {
                            File f = new File(dst, files[k]);
                            if (f.isDirectory()) continue;
                            this.copyFile(mainFiles[j], f);
                        }
                    }
                }
                out.write("<script language=\"javascript\">top.completeServiceFileUpload('Files have been uploaded successfully. This page will be auto refreshed shortly with the status of the created " + utilityString + " service ');" + "</script>");
                return true;
            }
            catch (Exception e) {
                log.error((Object)"File upload failed", (Throwable)e);
                out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('File upload FAILED. " + e.getMessage() + "');" + "</script>");
            }
        }
        return false;
    }

    private void copyFile(File src, File dst) throws IOException, FileNotFoundException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        DataHandler dh = new DataHandler(src.toURL());
        FileOutputStream out = new FileOutputStream(dst);
        dh.writeTo((OutputStream)out);
        out.flush();
    }
}

