/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.transport.HttpGetRequestProcessor;
import org.wso2.wsas.transport.util.AtomProcessor;
import org.wso2.wsas.transport.util.RssProcessor;

public class WSASServlet
extends AxisServlet {
    private static final long serialVersionUID = 3460108128756524161L;
    private Map getRequestProcessors = new LinkedHashMap();
    private static final QName ITEM_QN = new QName("http://www.wso2.org/products/wsas", "Item");
    private static final QName CLASS_QN = new QName("http://www.wso2.org/products/wsas", "Class");
    private RssProcessor rssProcessor = new RssProcessor();
    private AtomProcessor atomProcessor = new AtomProcessor();

    public void init(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this.configContext = (ConfigurationContext)servletContext.getAttribute("CONFIGURATION_CONTEXT");
        this.axisConfiguration = this.configContext.getAxisConfiguration();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
        this.servletConfig = config;
        this.populateGetRequestProcessors();
        this.initParams();
    }

    private void populateGetRequestProcessors() throws ServletException {
        try {
            OMElement docEle = ServerConfiguration.getInstance().getDocumentElement();
            if (docEle != null) {
                SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
                nsCtx.addNamespace("wsas", "http://www.wso2.org/products/wsas");
                AXIOMXPath xp = new AXIOMXPath("//wsas:HttpGetRequestProcessors/wsas:Processor");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                List nodeList = xp.selectNodes((Object)docEle);
                Iterator iter = nodeList.iterator();
                while (iter.hasNext()) {
                    OMElement processorEle = (OMElement)iter.next();
                    OMElement itemEle = processorEle.getFirstChildWithName(ITEM_QN);
                    if (itemEle == null) {
                        throw new ServletException("Required element, 'Item' not found!");
                    }
                    OMElement classEle = processorEle.getFirstChildWithName(CLASS_QN);
                    if (classEle == null) {
                        throw new ServletException("Required element, 'Class' not found!");
                    }
                    HttpGetRequestProcessor processor = (HttpGetRequestProcessor)Class.forName(classEle.getText().trim()).newInstance();
                    this.getRequestProcessors.put(itemEle.getText().trim(), processor);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        boolean isRequestHandled = false;
        try {
            String queryString;
            String requestURI = request.getRequestURI();
            if (requestURI.endsWith("/rss")) {
                this.rssProcessor.process(request, response, this.configContext);
                isRequestHandled = true;
            }
            if (requestURI.endsWith("/atom")) {
                this.atomProcessor.process(request, response, this.configContext);
                isRequestHandled = true;
            }
            if ((queryString = request.getQueryString()) != null) {
                Iterator iter = this.getRequestProcessors.keySet().iterator();
                while (iter.hasNext()) {
                    String item = (String)iter.next();
                    if (queryString.indexOf(item) != 0 || !queryString.equals(item) && queryString.indexOf("&") != item.length() && queryString.indexOf("=") != item.length()) continue;
                    ((HttpGetRequestProcessor)this.getRequestProcessors.get(item)).process(request, response, this.configContext);
                    isRequestHandled = true;
                    break;
                }
            }
            if (!isRequestHandled) {
                this.handleRestRequest(request, response);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    protected void handleRestRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.disableREST) {
            new AxisServlet.RestRequestProcessor((AxisServlet)this, "GET", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }
}

