/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.adminui.UIProcessor;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.util.WsasUtils;

public class UIInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = -7939917535315904295L;
    private static Log log = LogFactory.getLog((Class)UIInitializerServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        String resourceBase = servletContext.getRealPath(".");
        try {
            Hashtable files = new Hashtable();
            UIProcessor.createPages((String)resourceBase, (String)"ui-extensions-config.xml", files);
            Axis2XMLInfo axis2XMLInfo = this.getAxis2XMLInfo();
            WsasUtils.setServletContextProperties(servletContext, files, WsasUtils.isAdminConsoleEnabled(), axis2XMLInfo.getHttpPort(), axis2XMLInfo.getHttpsPort(), axis2XMLInfo.getServicePath());
        }
        catch (Exception e) {
            String msg = "Exception occurred while initializing the UI";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    private Axis2XMLInfo getAxis2XMLInfo() throws IOException, XMLStreamException, JaxenException {
        String text;
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        String axis2XML = serverConfiguration.getFirstProperty("Axis2Config.ConfigurationFile");
        boolean isURl = this.isURL(axis2XML);
        InputStream axis2XMLInStream = isURl ? new URL(axis2XML).openStream() : new FileInputStream(new File(axis2XML));
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(axis2XMLInStream);
        StAXOMBuilder builder = new StAXOMBuilder(xmlStreamReader);
        String servicePath = "services";
        AXIOMXPath xp = new AXIOMXPath("/axisconfig/parameter[@name='servicePath']");
        OMElement documentElement = builder.getDocumentElement();
        OMElement servicePathEle = (OMElement)xp.selectSingleNode((Object)documentElement);
        if (servicePathEle != null && (text = servicePathEle.getText()) != null) {
            servicePath = text;
        }
        xp = new AXIOMXPath("/axisconfig/transportReceiver[@name='http']/parameter[@name='port']");
        OMElement httpPortEle = (OMElement)xp.selectSingleNode((Object)documentElement);
        xp = new AXIOMXPath("/axisconfig/transportReceiver[@name='https']/parameter[@name='port']");
        OMElement httpsPortEle = (OMElement)xp.selectSingleNode((Object)documentElement);
        xp = new AXIOMXPath("/axisconfig/transportReceiver[@name='http']/parameter[@name='proxyPort']");
        Object obj = xp.selectSingleNode((Object)documentElement);
        if (obj != null) {
            httpPortEle = (OMElement)obj;
        }
        if ((obj = (xp = new AXIOMXPath("/axisconfig/transportReceiver[@name='https']/parameter[@name='proxyPort']")).selectSingleNode((Object)documentElement)) != null) {
            httpsPortEle = (OMElement)obj;
        }
        return new Axis2XMLInfo(servicePath, Integer.parseInt(httpsPortEle.getText()), Integer.parseInt(httpPortEle.getText()));
    }

    private boolean isURL(String axis2XMLLocation) {
        try {
            new URL(axis2XMLLocation);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static class Axis2XMLInfo {
        private String servicePath;
        private int httpsPort;
        private int httpPort;

        public Axis2XMLInfo(String servicePath, int httpsPort, int httpPort) {
            this.servicePath = servicePath;
            this.httpsPort = httpsPort;
            this.httpPort = httpPort;
        }

        public String getServicePath() {
            return this.servicePath;
        }

        public int getHttpsPort() {
            return this.httpsPort;
        }

        public int getHttpPort() {
            return this.httpPort;
        }
    }
}

