/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;

public class RequestRedirectionFilter
implements Filter {
    private String contextRoot;

    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig.getServletContext().setAttribute(this.getClass().getName(), (Object)this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        this.initContextRoot(httpServletRequest);
        if (httpServletRequest.getRequestURL().toString().indexOf(NetworkUtils.getLocalHostname()) == -1) {
            httpServletResponse.sendRedirect("https://" + NetworkUtils.getLocalHostname() + ":" + ServerManager.getInstance().getHttpsPort() + (this.contextRoot.equals("/") ? this.contextRoot : this.contextRoot + "/"));
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private void initContextRoot(HttpServletRequest request) {
        if (this.contextRoot != null && this.contextRoot.length() != 0) {
            return;
        }
        String contextRoot = request.getContextPath();
        if (contextRoot != null && contextRoot.length() == 0) {
            contextRoot = "/";
        }
        this.contextRoot = contextRoot;
    }

    public void destroy() {
    }
}

