/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.util.FileDownloadUtil;

public class FileDownloadServlet
extends AxisServlet {
    private static final Log log = LogFactory.getLog((Class)FileDownloadServlet.class);
    private static final long serialVersionUID = 6074514253507510250L;
    private FileDownloadUtil fileDownloadUtil;

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(406);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MessageContext msgCtx = null;
        try {
            msgCtx = this.createMessageContext(req, res);
            this.fileDownloadUtil.acquireResource(this.configContext, req, res);
        }
        catch (ServerException e) {
            String msg = "Cannot download file";
            log.error((Object)msg, (Throwable)e);
            if (msgCtx != null) {
                res.setStatus(500);
                this.handleFault(msgCtx, (OutputStream)res.getOutputStream(), AxisFault.makeFault((Throwable)e));
            }
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        this.configContext = (ConfigurationContext)servletContext.getAttribute("CONFIGURATION_CONTEXT");
        if (this.configContext == null) {
            this.configContext = ServerManager.getInstance().configContext;
        }
        this.axisConfiguration = this.configContext.getAxisConfiguration();
        this.fileDownloadUtil = new FileDownloadUtil();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
        this.servletConfig = servletConfig;
        this.initParams();
    }
}

