/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.serverinfo;

import java.io.FileReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.serverinfo.ServerInfo;
import org.wso2.wsas.serverinfo.Tomcat5xServerInfo;

public class Tomcat6xServerInfo
implements ServerInfo {
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private Properties props;
    private static Log log = LogFactory.getLog((Class)Tomcat5xServerInfo.class);

    public void setProperties(Properties props) {
        this.props = props;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void process() {
        String serverXML = this.props.getProperty("tomcat.server.xml");
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(serverXML));
            StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)parser);
            OMElement docEle = builder.getDocumentElement();
            OMElement serviceEle = docEle.getFirstChildWithName(new QName("Service"));
            String keystoreFile = "";
            String keystorePass = "";
            Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
            while (iter.hasNext()) {
                OMElement omEle = (OMElement)iter.next();
                OMAttribute sslProtocolAttr = omEle.getAttribute(new QName("sslProtocol"));
                if (sslProtocolAttr != null) {
                    this.httpsPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
                    keystoreFile = omEle.getAttribute(new QName("keystoreFile")).getAttributeValue();
                    keystorePass = omEle.getAttribute(new QName("keystorePass")).getAttributeValue();
                    continue;
                }
                OMAttribute sslEnabledAttr = omEle.getAttribute(new QName("SSLEnabled"));
                OMAttribute protocolAttr = omEle.getAttribute(new QName("protocol"));
                if (protocolAttr == null || !protocolAttr.getAttributeValue().equalsIgnoreCase("HTTP/1.1") || sslEnabledAttr != null && !sslEnabledAttr.getAttributeValue().equalsIgnoreCase("false")) continue;
                this.httpPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
            }
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Type", "JKS");
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Location", keystoreFile);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Password", keystorePass);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.KeyPassword", keystorePass);
        }
        catch (Exception e) {
            String msg = "Cannot read HTTP and HTTPS ports from Tomcat server.xml";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }
}

