/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.serverinfo;

import java.io.FileReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.serverinfo.ServerInfo;

public class Tomcat41xServerInfo
implements ServerInfo {
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private String keystoreFile;
    private String keystorePass;
    private Properties props;
    private boolean isHttpPortSet;
    private boolean isHttpsPortSet;

    public void setProperties(Properties props) {
        this.props = props;
    }

    public void process() {
        String serverXML = this.props.getProperty("tomcat.server.xml");
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(serverXML));
            StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)parser);
            OMElement docEle = builder.getDocumentElement();
            OMElement serviceEle = docEle.getFirstChildWithName(new QName("Service"));
            Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
            while (iter.hasNext()) {
                OMElement omEle = (OMElement)iter.next();
                OMAttribute classNameAttr = omEle.getAttribute(new QName("className"));
                OMAttribute schemeAttr = omEle.getAttribute(new QName("scheme"));
                if (classNameAttr != null && classNameAttr.getAttributeValue().equals("org.apache.coyote.tomcat4.CoyoteConnector") && schemeAttr != null && schemeAttr.getAttributeValue().equalsIgnoreCase("https")) {
                    if (this.isHttpsPortSet) continue;
                    this.httpsPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
                    this.isHttpsPortSet = true;
                    OMElement factoryEle = omEle.getFirstChildWithName(new QName("Factory"));
                    this.keystoreFile = factoryEle.getAttribute(new QName("keystoreFile")).getAttributeValue();
                    this.keystorePass = factoryEle.getAttribute(new QName("keystorePass")).getAttributeValue();
                    continue;
                }
                if (classNameAttr == null || !classNameAttr.getAttributeValue().equals("org.apache.coyote.tomcat4.CoyoteConnector") || this.isHttpPortSet) continue;
                this.httpPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
                this.isHttpPortSet = true;
            }
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Type", "JKS");
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Location", this.keystoreFile);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Password", this.keystorePass);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.KeyPassword", this.keystorePass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot read HTTP and HTTPS ports from Tomcat server.xml : " + e);
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }
}

