/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.serverinfo;

import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.serverinfo.ServerInfo;

public class JBossServerInfo
implements ServerInfo {
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private String keystoreFile;
    private String keystorePass;
    private Properties props;

    public void setProperties(Properties props) {
        this.props = props;
    }

    public void process() {
        try {
            File tomcatServerXML = new File(this.props.getProperty("tomcat.server.xml"));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(tomcatServerXML));
            StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)parser);
            OMElement docEle = builder.getDocumentElement();
            OMElement serviceEle = docEle.getFirstChildWithName(new QName("Service"));
            Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
            while (iter.hasNext()) {
                OMElement omEle = (OMElement)iter.next();
                OMAttribute sslProtocolAttr = omEle.getAttribute(new QName("sslProtocol"));
                if (sslProtocolAttr != null) {
                    this.httpsPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
                    this.keystoreFile = omEle.getAttribute(new QName("keystoreFile")).getAttributeValue();
                    this.keystorePass = omEle.getAttribute(new QName("keystorePass")).getAttributeValue();
                    continue;
                }
                OMAttribute protocolAttr = omEle.getAttribute(new QName("protocol"));
                if (protocolAttr != null) continue;
                this.httpPort = Integer.parseInt(omEle.getAttribute(new QName("port")).getAttributeValue());
            }
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Type", "JKS");
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Location", this.keystoreFile);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Password", this.keystorePass);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.KeyPassword", this.keystorePass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot read HTTP and HTTPS ports from Tomcat server.xml : " + e);
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }
}

