/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.serverinfo;

import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.wso2.wsas.serverinfo.ServerInfo;

public class GeronimoServerInfo
implements ServerInfo {
    public static final String GERONIMO_CONFIG_NAMESPACE = "http://geronimo.apache.org/xml/ns/attributes-1.1";
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private Properties props;
    private static Log log = LogFactory.getLog((Class)GeronimoServerInfo.class);

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public void process() {
        String configXml = this.props.getProperty("geronimo.server.xml");
        String geronimoVersion = this.props.getProperty("appserver.version");
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(configXml));
            StAXOMBuilder staxOMBuilder = new StAXOMBuilder(parser);
            OMElement docElement = staxOMBuilder.getDocumentElement();
            OMElement omElement = this.getOMElement("//ns:module[@name='geronimo/tomcat/" + geronimoVersion + "/car']", docElement);
            if (omElement != null) {
                OMElement defaultWebConnector;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Going to process a Geronimo-Tomcat container");
                }
                if ((defaultWebConnector = this.getOMElement("//ns:gbean[@name='TomcatWebConnector']", omElement)) != null) {
                    this.httpPort = Integer.parseInt(this.getNodeString("//ns:gbean[@name='TomcatWebConnector']/ns:attribute[@name='port']/text()", omElement));
                } else {
                    List gbeanList = this.getNodes("//ns:module[@name='geronimo/tomcat/" + geronimoVersion + "/car']/" + "ns:gbean[ns:attribute[@name='protocol' and " + "text()='HTTP']]/ns:attribute[@name='port']/text()", omElement);
                    if (gbeanList.size() > 0) {
                        OMText value = (OMText)gbeanList.get(0);
                        this.httpsPort = Integer.parseInt(value.getText());
                    } else {
                        log.error((Object)"Could not find the http port number for Geronimo-Tomcat container");
                    }
                }
                log.info((Object)("Http port for Geromimo Tomcat server ==> " + this.httpPort));
                OMElement defaultSSLConnector = this.getOMElement("//ns:gbean[@name='TomcatWebSSLConnector']", omElement);
                if (defaultSSLConnector != null) {
                    this.httpsPort = Integer.parseInt(this.getNodeString("//ns:gbean[@name='TomcatWebSSLConnector']/ns:attribute[@name='port']/text()", omElement));
                } else {
                    List gbeanList = this.getNodes("//ns:module[@name='geronimo/tomcat/" + geronimoVersion + "/car']/" + "ns:gbean[ns:attribute[@name='protocol' and " + "text()='HTTPS']]/ns:attribute[@name='port']/text()", omElement);
                    if (gbeanList.size() > 0) {
                        OMText value = (OMText)gbeanList.get(0);
                        this.httpsPort = Integer.parseInt(value.getText());
                    } else {
                        log.error((Object)"Could not find the https port number for Geronimo-Tomcat container");
                    }
                }
                log.info((Object)("Https port for Geronimo-Tomcat server ==> " + this.httpsPort));
            } else {
                omElement = this.getOMElement("//ns:module[@name='geronimo/jetty/" + geronimoVersion + "car']", docElement);
                if (omElement != null) {
                    OMElement defaultWebConnector = this.getOMElement("//ns:gbean[@name='JettyWebConnector']", omElement);
                    if (defaultWebConnector != null) {
                        this.httpPort = Integer.parseInt(this.getNodeString("//ns:gbean[@name='JettyWebConnector']/ns:attribute[@name='port']/text()", omElement));
                    } else {
                        List gbeanList = this.getNodes("//ns:module[@name='geronimo/jetty/" + geronimoVersion + "car']/" + "ns:gbean[ns:attribute[@name='protocol' and " + "text()='HTTPS']]/ns:attribute[@name='port']/text()", omElement);
                        if (gbeanList.size() > 0) {
                            OMText value = (OMText)gbeanList.get(0);
                            this.httpPort = Integer.parseInt(value.getText());
                        } else {
                            log.error((Object)"Could not find the http port number for Geronimo-Jetty container");
                        }
                    }
                    log.info((Object)("Http port for Geromimo Jetty server ==> " + this.httpPort));
                    OMElement defaultSSLConnector = this.getOMElement("//ns:gbean[@name='JettySSLConnector']", omElement);
                    if (defaultSSLConnector != null) {
                        this.httpsPort = Integer.parseInt(this.getNodeString("//ns:gbean[@name='JettySSLConnector']/ns:attribute[@name='port']/text()", omElement));
                    } else {
                        List gbeanList = this.getNodes("//ns:module[@name='geronimo/jetty/" + geronimoVersion + "car']/" + "ns:gbean[ns:attribute[@name='protocol' " + "and text()='HTTPS']]/ns:attribute[@name='port']/text()", omElement);
                        if (gbeanList.size() > 0) {
                            OMText value = (OMText)gbeanList.get(0);
                            this.httpsPort = Integer.parseInt(value.getText());
                        } else {
                            log.error((Object)"Could not find the http port number for Geronimo-Jetty container");
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Https port for Geromimo-Jetty server ==> " + this.httpsPort));
                    }
                } else {
                    log.warn((Object)"could not find the http and https ports for Geronimo server");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Cannot read HTTP and HTTPS ports from server.xml";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private List getNodes(String xpathString, OMElement parentElement) throws JaxenException {
        XPath xpath = this.getXPath(xpathString);
        return xpath.selectNodes((Object)parentElement);
    }

    private String getNodeString(String xpathString, OMElement parentElement) throws JaxenException {
        XPath xpath = this.getXPath(xpathString);
        return xpath.stringValueOf((Object)parentElement);
    }

    private OMElement getOMElement(String xpathString, OMElement parentElement) throws JaxenException {
        XPath xpath = this.getXPath(xpathString);
        return (OMElement)xpath.selectSingleNode((Object)parentElement);
    }

    private XPath getXPath(String xpathString) throws JaxenException {
        SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
        nsCtx.addNamespace("ns", GERONIMO_CONFIG_NAMESPACE);
        AXIOMXPath xpath = new AXIOMXPath(xpathString);
        xpath.setNamespaceContext((NamespaceContext)nsCtx);
        return xpath;
    }
}

