/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security.pox;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceDO;

public class POXSecurityHandler
implements Handler {
    private static Log log = LogFactory.getLog((Class)POXSecurityHandler.class);
    private HandlerDescription description;
    private PersistenceManager pm = new PersistenceManager();

    public void cleanup() {
    }

    public void init(HandlerDescription description) {
        this.description = description;
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        int index;
        if (!msgCtx.isDoingREST() || !msgCtx.getIncomingTransportName().equals("https")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        AxisService service = msgCtx.getAxisService();
        if (service == null) {
            log.info((Object)"Service not dispatched");
            return Handler.InvocationResponse.CONTINUE;
        }
        ServiceDO serviceDO = this.pm.getService(service.getName(), "$EMPTY$");
        if (serviceDO != null) {
            if (!serviceDO.getIsUTAuthEnabled()) {
                return Handler.InvocationResponse.CONTINUE;
            }
        } else {
            return Handler.InvocationResponse.CONTINUE;
        }
        HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String url = request.getRequestURL().toString();
        String protocol = url.substring(0, index = url.indexOf("://"));
        if (!protocol.equalsIgnoreCase("https")) {
            HttpServletResponse response = (HttpServletResponse)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            try {
                String requestURI = request.getRequestURI();
                response.sendRedirect("https://" + NetworkUtils.getLocalHostname() + ":" + ServerManager.getInstance().getHttpsPort() + requestURI);
                return Handler.InvocationResponse.ABORT;
            }
            catch (IOException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        try {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            Map map = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
            String tmp = (String)map.get("Authorization");
            String username = null;
            String password = null;
            if (tmp != null) {
                tmp = tmp.trim();
            }
            if (tmp != null && tmp.startsWith("Basic ")) {
                int i = (tmp = new String(Base64.decode((String)tmp.substring(6)))).indexOf(58);
                username = i == -1 ? tmp : tmp.substring(0, i);
                if (i != -1 && (password = tmp.substring(i + 1)) != null && password.equals("")) {
                    password = null;
                }
            }
            if (username == null || password == null || password.trim().length() == 0 || username.trim().length() == 0) {
                msgCtx.setProperty("axis2.http.response.state", (Object)String.valueOf(401));
                msgCtx.setProperty("axis2.authentication.realm", (Object)ServerConfiguration.getInstance().getFirstProperty("Name"));
                throw new AxisFault("Authentication Failure");
            }
            Document doc = Axis2Util.getDocumentFromSOAPEnvelope((SOAPEnvelope)msgCtx.getEnvelope(), (boolean)false);
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecUsernameToken utBuilder = new WSSecUsernameToken();
            utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            utBuilder.setUserInfo(username, password);
            utBuilder.build(doc, secHeader);
            WSSecTimestamp tsBuilder = new WSSecTimestamp();
            tsBuilder.build(doc, secHeader);
            msgCtx.setEnvelope(Axis2Util.getSOAPEnvelopeFromDOMDocument((Document)doc, (boolean)false));
        }
        catch (WSSecurityException wssEx) {
            throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.description;
    }

    public String getName() {
        return "REST/POX Security handler";
    }

    public Parameter getParameter(String name) {
        return this.description.getParameter(name);
    }
}

