/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security;

import java.util.Vector;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.WSHandlerResult;
import org.wso2.utils.ServerException;
import org.wso2.wsas.security.ClientUserPasswordCallbackHandler;
import org.wso2.wsas.security.ServicePasswordCallbackHandler;

public class WSS4JUtil {
    public static WSUsernameTokenPrincipal getUsernameTokenPrincipal(MessageContext mc) throws ServerException {
        Vector results = (Vector)mc.getProperty("RECV_RESULTS");
        if (results == null) {
            throw new ServerException("No security results available in the message context");
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1) continue;
                return (WSUsernameTokenPrincipal)wser.get((Object)"principal");
            }
        }
        return null;
    }

    public static Parameter getPasswordCallBackRefParameter(String serviceId, String serviceVersion) {
        Parameter param = new Parameter();
        param.setName("passwordCallbackRef");
        param.setValue((Object)new ServicePasswordCallbackHandler(serviceId, serviceVersion));
        return param;
    }

    public static Parameter getPasswordCallBackRefParameter(String serviceId) {
        Parameter param = new Parameter();
        param.setName("passwordCallbackRef");
        param.setValue((Object)new ServicePasswordCallbackHandler(serviceId));
        return param;
    }

    public static Parameter getClientUsernameTokenHandler(String password) {
        Parameter param = new Parameter();
        param.setName("passwordCallbackRef");
        param.setValue((Object)new ClientUserPasswordCallbackHandler(password));
        return param;
    }
}

