/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security;

import java.io.File;
import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;

public class WSASJMXAuthenticator
implements JMXAuthenticator {
    private static Log log = LogFactory.getLog((Class)WSASJMXAuthenticator.class);

    public Subject authenticate(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials required");
            }
            throw new SecurityException("Credentials should be String[]");
        }
        String[] aCredentials = (String[])credentials;
        if (aCredentials.length < 2) {
            throw new SecurityException("Credentials should have at least username & password");
        }
        String username = aCredentials[0];
        String password = aCredentials[1];
        boolean authenticated = false;
        PersistenceManager pm = new PersistenceManager();
        ServiceUserDO user = pm.getUser(username);
        if (user != null) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(serverConfig.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), serverConfig.getFirstProperty("Security.KeyStore.Password"), serverConfig.getFirstProperty("Security.KeyStore.KeyAlias"), serverConfig.getFirstProperty("Security.KeyStore.KeyPassword"), serverConfig.getFirstProperty("Security.KeyStore.Type"));
            try {
                String pwd = new String(cryptoUtil.base64DecodeAndDecrypt(user.getPassword()));
                if (pwd.equals(password)) {
                    authenticated = true;
                }
            }
            catch (CryptoException e) {
                String msg = "Could not decrypt password";
                log.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, e);
            }
        }
        if (authenticated) {
            return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        throw new SecurityException("Username and/or password are incorrect, or you do not have the necessary access rights.");
    }
}

