/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;

public class ServicePasswordCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog((Class)ServicePasswordCallbackHandler.class);
    private String serviceId;
    private String serviceVersion = "$EMPTY$";

    public ServicePasswordCallbackHandler(String serviceId, String serviceVersion) {
        this.serviceId = serviceId;
        this.serviceVersion = serviceVersion;
    }

    public ServicePasswordCallbackHandler(String serviceId) {
        this.serviceId = serviceId;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block4: for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback passwordCallback = (WSPasswordCallback)callbacks[i];
                String username = passwordCallback.getIdentifer();
                String storedPasswd = this.getPassword(username, this.serviceId, this.serviceVersion);
                switch (passwordCallback.getUsage()) {
                    case 1: 
                    case 3: {
                        passwordCallback.setPassword(this.getPrivateKeyPassword(username));
                        break;
                    }
                    case 5: {
                        boolean authneticated;
                        String receivedPasswd = passwordCallback.getPassword();
                        boolean bl = authneticated = receivedPasswd != null && receivedPasswd.equals(storedPasswd);
                        if (authneticated) continue block4;
                        throw new UnsupportedCallbackException(callbacks[i], "check failed");
                    }
                    default: {
                        if (storedPasswd == null) {
                            storedPasswd = "";
                        }
                        passwordCallback.setPassword(storedPasswd);
                        break;
                    }
                }
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private String getPrivateKeyPassword(String username) throws IOException {
        PersistenceManager pm = new PersistenceManager();
        KeyStoreDO ksDO = pm.getService(this.serviceId, this.serviceVersion).getPrivateKeyStore();
        if (username.equals(ksDO.getPrivateKeyAlias())) {
            try {
                ServerConfiguration config = ServerConfiguration.getInstance();
                CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
                return new String(cryptoUtil.base64DecodeAndDecrypt(ksDO.getPrivateKeyPassword()));
            }
            catch (CryptoException e) {
                throw new IOException(e.getMessage());
            }
        }
        return null;
    }

    private String getPassword(String username, String serviceId, String serviceVersion) {
        ServiceUserDO serviceUser;
        PersistenceManager pm = new PersistenceManager();
        if (serviceVersion == null || serviceVersion.trim().length() == 0) {
            serviceVersion = "$EMPTY$";
        }
        if ((serviceUser = pm.getUser(username)) == null) {
            return null;
        }
        ServiceDO service = pm.getService(serviceId, serviceVersion);
        Set assignedRoles = service.getRoles();
        boolean isValidRoleFound = false;
        Iterator iterator = assignedRoles.iterator();
        while (iterator.hasNext()) {
            ServiceUserRoleDO role = (ServiceUserRoleDO)iterator.next();
            if (!pm.userHasRole(username, role)) continue;
            isValidRoleFound = true;
            break;
        }
        if (!isValidRoleFound && !service.getUsers().contains(serviceUser)) {
            return null;
        }
        String password = null;
        try {
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            password = new String(cryptoUtil.base64DecodeAndDecrypt(serviceUser.getPassword()));
        }
        catch (CryptoException e) {
            log.error((Object)"Exception occurred while decrypting password", (Throwable)e);
        }
        return password;
    }
}

