/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.X509NameTokenizer;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.security.XKMSCryptoClient;

public class ServerCrypto
implements Crypto {
    private static Log log = LogFactory.getLog((Class)ServerCrypto.class);
    public static final String PROP_ID_KEY_STORE = "org.wso2.wsas.security.wso2wsas.crypto.keystore";
    public static final String PROP_ID_TRUST_STORES = "org.wso2.wsas.security.wso2wsas.crypto.truststores";
    public static final String PROP_ID_CERT_PROVIDER = "org.wso2.wsas.security.wso2wsas.crypto.cert.provider";
    public static final String PROP_ID_DEFAULT_ALIAS = "org.wso2.wsas.security.wso2wsas.crypto.alias";
    public static final String PROP_ID_XKMS_SERVICE_URL = "org.wso2.wsas.security.wso2wsas.crypto.xkms.url";
    public static final String PROP_ID_XKMS_SERVICE_PASS_PHRASE = "org.wso2.wsas.security.wso2wsas.crypto.xkms.pass";
    private static final String SKI_OID = "2.5.29.14";
    private Properties properties = null;
    private KeyStore keystore = null;
    private KeyStore cacerts = null;
    private ArrayList trustStores = null;
    private static CertificateFactory certFact;
    private PersistenceManager persistenceMgr = new PersistenceManager();
    private Boolean useXkms;

    public ServerCrypto(Properties prop) throws CredentialException, IOException {
        this(prop, ServerCrypto.class.getClassLoader());
    }

    public ServerCrypto(Properties prop, ClassLoader loader) throws CredentialException, IOException {
        this.properties = prop;
        String ksId = this.properties.getProperty(PROP_ID_KEY_STORE);
        this.keystore = this.findKeyStore(ksId, loader);
        String trustStoreIds = this.properties.getProperty(PROP_ID_TRUST_STORES);
        if (trustStoreIds != null && trustStoreIds.trim().length() != 0) {
            String[] ids = trustStoreIds.trim().split(",");
            this.trustStores = new ArrayList(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                this.trustStores.add(i, this.findKeyStore(ids[i], loader));
            }
        }
        String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
        FileInputStream cacertsIs = new FileInputStream(cacertsPath);
        try {
            String cacertsPasswd = this.properties.getProperty("org.wso2.wsas.security.wso2wsas.crypto.cacerts.password", "changeit");
            this.cacerts = KeyStore.getInstance(KeyStore.getDefaultType());
            this.cacerts.load(cacertsIs, cacertsPasswd.toCharArray());
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new CredentialException(3, "secError00", (Throwable)e);
        }
        finally {
            ((InputStream)cacertsIs).close();
        }
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        CertPath path;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.insertElementAt(certs[i], 0);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        if (alias == null) {
            throw new Exception("alias is null");
        }
        boolean b = this.keystore.isKeyEntry(alias);
        if (!b && this.useXKMS()) {
            PrivateKey privateKey = XKMSCryptoClient.getPrivateKey(alias, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL), this.properties.getProperty(PROP_ID_XKMS_SERVICE_PASS_PHRASE));
            if (privateKey == null) {
                log.error((Object)("Cannot find key for alias" + alias));
                throw new Exception("Cannot find key for alias: " + alias);
            }
            return privateKey;
        }
        if (!b) {
            log.error((Object)("Cannot find key for alias: " + alias));
            throw new Exception("Cannot find key for alias: " + alias);
        }
        Key keyTmp = this.keystore.getKey(alias, password.toCharArray());
        if (!(keyTmp instanceof PrivateKey)) {
            throw new Exception("Key is not a private key, alias: " + alias);
        }
        return (PrivateKey)keyTmp;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        Certificate[] certs = new Certificate[]{};
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.trustStores != null) {
                KeyStore store;
                Iterator trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (certs = (store = (KeyStore)trustStoreIter.next()).getCertificateChain(alias)) == null) {
                    cert = store.getCertificate(alias);
                }
            }
            if (certs == null && cert == null && this.cacerts != null && ((certs = this.cacerts.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                certs = new Certificate[]{cert};
            } else if (certs == null && this.useXKMS()) {
                return XKMSCryptoClient.getCertificates(alias, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL));
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[]{};
        if (certs != null) {
            x509certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509certs[i] = (X509Certificate)certs[i];
            }
        }
        return x509certs;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            KeyStore store;
            Iterator trustStoreIter;
            String alias = null;
            if (this.keystore != null && (alias = this.keystore.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.keystore, cert);
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = (store = (KeyStore)trustStoreIter.next()).getCertificateAlias(cert)) == null) {
                }
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = this.findAliasForCert(store = (KeyStore)trustStoreIter.next(), cert)) == null) {
                }
            }
            if (alias == null && this.cacerts != null && (alias = this.cacerts.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.cacerts, cert);
            }
            if (alias != null) {
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        if (this.useXKMS()) {
            return XKMSCryptoClient.getAliasForX509Certificate((X509Certificate)cert, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL));
        }
        return null;
    }

    private String findAliasForCert(KeyStore ks, Certificate cert) throws KeyStoreException {
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate cert2 = (X509Certificate)ks.getCertificate(alias);
            if (!cert2.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, null, false);
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, serialNumber, true);
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert(cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        if (this.useXKMS()) {
            return XKMSCryptoClient.getAliasForX509Certificate(skiBytes, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL));
        }
        return null;
    }

    public String getDefaultX509Alias() {
        return this.properties.getProperty(PROP_ID_DEFAULT_ALIAS);
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"});
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new WSSecurityException(7, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (certFact == null) {
            try {
                String provider = this.properties.getProperty(PROP_ID_CERT_PROVIDER);
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return certFact;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        boolean result;
        if (this.useXKMS() && (result = XKMSCryptoClient.validateCertPath(certs, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL)))) {
            return true;
        }
        result = this.validateCertPath(this.keystore, certs);
        if (!result) {
            Iterator trustStoreIter = this.trustStores.iterator();
            while (!result) {
                result = this.validateCertPath((KeyStore)trustStoreIter.next(), certs);
            }
        }
        if (!result && this.cacerts != null) {
            result = this.validateCertPath(this.cacerts, certs);
        }
        return result;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        String[] xkmsAliases;
        Vector<String> aliases = new Vector<String>();
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                Vector foundRDN;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = this.splitAndTrim(cert.getSubjectDN().getName()))) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        if (aliases.isEmpty() && this.useXKMS() && (xkmsAliases = XKMSCryptoClient.getAliasesForDN(subjectDN, this.properties.getProperty(PROP_ID_XKMS_SERVICE_URL))) != null) {
            for (int i = 0; i < xkmsAliases.length; ++i) {
                aliases.add(xkmsAliases[i]);
            }
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore findKeyStore(String ksId, ClassLoader loader) throws CredentialException, IOException {
        String location = this.getKeyStoreLocation(ksId);
        InputStream is = null;
        DiscoverResources disc = new DiscoverResources();
        disc.addClassLoader(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        disc.addClassLoader(loader);
        ResourceIterator iterator = disc.findResources(location);
        if (iterator.hasNext()) {
            Resource resource = iterator.nextResource();
            is = resource.getResourceAsStream();
        }
        if (is == null) {
            try {
                is = new FileInputStream(location);
            }
            catch (Exception e) {
                throw new CredentialException(3, "proxyNotFound", new Object[]{location});
            }
        }
        try {
            KeyStore keyStore = this.load(is, ksId);
            return keyStore;
        }
        finally {
            is.close();
        }
    }

    private KeyStore load(InputStream input, String ksId) throws CredentialException {
        if (input == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        try {
            String provider = null;
            String keyStoreProvider = this.getKeyStoreProvider(ksId);
            if (keyStoreProvider != null) {
                provider = this.properties.getProperty(keyStoreProvider);
            }
            KeyStore tempStore = provider == null || provider.trim().length() == 0 ? KeyStore.getInstance(this.properties.getProperty(this.getKeyStoreLocation(ksId), KeyStore.getDefaultType())) : KeyStore.getInstance(this.properties.getProperty(this.getKeyStoreType(ksId), KeyStore.getDefaultType()), provider);
            String password = this.getKeyStorePassword(ksId);
            tempStore.load(input, password == null || password.length() == 0 ? new char[]{} : password.toCharArray());
            return tempStore;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CredentialException(3, "ioError00", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new CredentialException(3, "secError00", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CredentialException(-1, "error00", (Throwable)e);
        }
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber) throws WSSecurityException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                Vector certRDN;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509cert = cert;
                if (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0 || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    private Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    private boolean validateCertPath(KeyStore ks, Certificate[] certs) throws WSSecurityException {
        try {
            List<Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            PKIXParameters param = new PKIXParameters(ks);
            param.setRevocationEnabled(false);
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
            CertPathValidator certPathValidator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            certPathValidator.validate(path, param);
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertPathValidatorException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        return true;
    }

    private String getKeyStorePassword(String ksId) throws ServerException {
        KeyStoreDO keyStore = this.persistenceMgr.getKeyStore(ksId);
        if (keyStore != null) {
            String passwd;
            String storePassword = keyStore.getStorePassword();
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            try {
                passwd = new String(cryptoUtil.base64DecodeAndDecrypt(storePassword));
            }
            catch (CryptoException e) {
                throw new ServerException((Throwable)e);
            }
            return passwd;
        }
        return null;
    }

    private String getKeyStoreType(String ksId) {
        KeyStoreDO keyStore = this.persistenceMgr.getKeyStore(ksId);
        if (keyStore != null) {
            return keyStore.getKeyStoreType();
        }
        return null;
    }

    private String getKeyStoreProvider(String ksId) {
        KeyStoreDO keyStore = this.persistenceMgr.getKeyStore(ksId);
        if (keyStore != null) {
            return keyStore.getProvider();
        }
        return null;
    }

    private String getKeyStoreLocation(String ksId) {
        KeyStoreDO keyStore = this.persistenceMgr.getKeyStore(ksId);
        if (keyStore != null) {
            return keyStore.getFilePath();
        }
        return null;
    }

    private boolean useXKMS() {
        if (this.useXkms != null) {
            return this.useXkms;
        }
        AxisConfiguration axisConfiguration = ListenerManager.defaultConfigurationContext.getAxisConfiguration();
        Parameter parameter = axisConfiguration.getParameter("XKMSConfig");
        if (parameter == null) {
            this.useXkms = Boolean.FALSE;
            return this.useXkms;
        }
        OMElement parameterElement = parameter.getParameterElement();
        OMAttribute attribute = parameterElement.getAttribute(new QName("enabled"));
        if (attribute != null) {
            String value = attribute.getAttributeValue();
            this.useXkms = Boolean.valueOf(value);
        }
        OMElement urlElement = parameterElement.getFirstChildWithName(new QName("URL"));
        this.properties.setProperty(PROP_ID_XKMS_SERVICE_URL, urlElement.getText());
        OMElement passPhraseElement = parameterElement.getFirstChildWithName(new QName("PassPhrase"));
        this.properties.setProperty(PROP_ID_XKMS_SERVICE_PASS_PHRASE, passPhraseElement.getText());
        return this.useXkms;
    }
}

