/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.security;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.SCTIssuerConfig;
import org.apache.rahas.impl.TokenCancelerConfig;
import org.wso2.utils.ServerException;

public class RahasUtil {
    public static Parameter getSCTIssuerConfigParameter(String cryptoImpl, Properties cryptoProperties, int keyComputation, String proofKeyType, boolean addRequestedAttachedRef, boolean addRequestedUnattachedRef) throws ServerException {
        if (cryptoImpl == null || "".equals(cryptoImpl)) {
            throw new ServerException("Crypto impl missing");
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement paramElem = fac.createOMElement(new QName("parameter"), null);
        paramElem.addAttribute(fac.createOMAttribute("name", null, SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart()));
        OMElement elem = fac.createOMElement(SCTIssuerConfig.SCT_ISSUER_CONFIG, (OMContainer)paramElem);
        OMElement cryptoPropElem = fac.createOMElement(AbstractIssuerConfig.CRYPTO_PROPERTIES, (OMContainer)elem);
        OMElement cryptoElem = fac.createOMElement(AbstractIssuerConfig.CRYPTO, (OMContainer)cryptoPropElem);
        cryptoElem.addAttribute(fac.createOMAttribute("provider", null, cryptoImpl));
        Enumeration<Object> keysEnum = cryptoProperties.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            OMElement prop = fac.createOMElement(new QName("property"), (OMContainer)cryptoElem);
            prop.addAttribute(fac.createOMAttribute("name", null, key));
            prop.setText(cryptoProperties.getProperty(key));
        }
        if (keyComputation != 2 && keyComputation != 3 && keyComputation != 1) {
            keyComputation = 3;
        }
        OMElement keyCompElem = fac.createOMElement(AbstractIssuerConfig.KeyComputation.KEY_COMPUTATION, (OMContainer)elem);
        keyCompElem.setText(Integer.toString(keyComputation));
        if (proofKeyType == null || "".equals(proofKeyType)) {
            proofKeyType = "BinarySecret";
        } else if (!"BinarySecret".equals(proofKeyType) || "EncryptedKey".equals(proofKeyType)) {
            throw new ServerException("Invalid proof token type configuration : " + proofKeyType);
        }
        OMElement proofKeyTypeElem = fac.createOMElement(AbstractIssuerConfig.PROOF_KEY_TYPE, (OMContainer)elem);
        proofKeyTypeElem.setText(proofKeyType);
        if (addRequestedAttachedRef) {
            fac.createOMElement(AbstractIssuerConfig.ADD_REQUESTED_ATTACHED_REF, (OMContainer)elem);
        }
        if (addRequestedUnattachedRef) {
            fac.createOMElement(AbstractIssuerConfig.ADD_REQUESTED_UNATTACHED_REF, (OMContainer)elem);
        }
        Parameter param = new Parameter();
        param.setName(SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart());
        param.setParameterElement(paramElem);
        return param;
    }

    public static Parameter getTokenCancelerConfigParameter() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement paramElem = fac.createOMElement(new QName("parameter"), null);
        paramElem.addAttribute(fac.createOMAttribute("name", null, TokenCancelerConfig.TOKEN_CANCELER_CONFIG.getLocalPart()));
        fac.createOMElement(TokenCancelerConfig.TOKEN_CANCELER_CONFIG, (OMContainer)paramElem);
        Parameter param = new Parameter();
        param.setName(TokenCancelerConfig.TOKEN_CANCELER_CONFIG.getLocalPart());
        param.setParameterElement(paramElem);
        return param;
    }
}

