/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dataobject;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;

public class ServiceUserDO
extends AbstractDataObject {
    private String username;
    private String password;
    private Date lastLoggedIn;
    private String lastLoginIP;
    private String lastFailedLoginIP;
    private Date lastFailedLogIn;
    private Set services = new HashSet();
    private Set roles = new HashSet();
    private String description;

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceUserDO && this.username.trim().equals(((ServiceUserDO)obj).getUsername());
    }

    public boolean hasRole(String role) {
        return this.roles.contains(new ServiceUserRoleDO(role));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public Set getServices() {
        return this.services;
    }

    public void setServices(Set services) {
        this.services = services;
    }

    public void addService(ServiceDO service) {
        service.getUsers().add(this);
        this.services.add(service);
    }

    public void removeService(ServiceDO service) {
        this.services.remove(service);
        service.getUsers().remove(this);
    }

    public void addRole(ServiceUserRoleDO role) {
        this.roles.add(role);
        role.getUsers().add(this);
    }

    public String toString() {
        return this.username;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getLastLoggedIn() {
        return this.lastLoggedIn;
    }

    public void setLastLoggedIn(Date lastLoggedIn) {
        this.lastLoggedIn = lastLoggedIn;
    }

    public Date getLastFailedLogIn() {
        return this.lastFailedLogIn;
    }

    public void setLastFailedLogIn(Date lastFailedLogIn) {
        this.lastFailedLogIn = lastFailedLogIn;
    }

    public String getLastLoginIP() {
        return this.lastLoginIP;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this.lastLoginIP = lastLoginIP;
    }

    public String getLastFailedLoginIP() {
        return this.lastFailedLoginIP;
    }

    public void setLastFailedLoginIP(String lastFailedLoginIP) {
        this.lastFailedLoginIP = lastFailedLoginIP;
    }
}

