/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ServiceParameterDO;
import org.wso2.wsas.persistence.dataobject.ServicePolicyDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.dataobject.TransportDO;

public class ServiceDO
extends AbstractDataObject {
    private boolean isUTAuthEnabled;
    private String documentation;
    private boolean isActive;
    private boolean isExposedOnAllTransports;
    private ServiceIdentifierDO serviceIdentifierDO;
    private Set policies = new HashSet();
    private Set operations = new HashSet();
    private Set engagedModules = new HashSet();
    private ServiceGroupDO serviceGroup;
    private Set parameters = new HashSet();
    private Set users = new HashSet();
    private Set roles = new HashSet();
    private Set transports = new HashSet();
    private SecurityScenarioDO securityScenario;
    private KeyStoreDO privateKeyStore;
    private Set trustedCertStores = new HashSet();

    public ServiceIdentifierDO getServiceIdentifierDO() {
        return this.serviceIdentifierDO;
    }

    public void setServiceIdentifierDO(ServiceIdentifierDO serviceIdentifierDO) {
        this.serviceIdentifierDO = serviceIdentifierDO;
    }

    public boolean getIsUTAuthEnabled() {
        return this.isUTAuthEnabled;
    }

    public void setIsUTAuthEnabled(boolean utAuthEnabled) {
        this.isUTAuthEnabled = utAuthEnabled;
    }

    public boolean getIsExposedOnAllTransports() {
        return this.isExposedOnAllTransports;
    }

    public void setIsExposedOnAllTransports(boolean isExposedOnAllTransports) {
        this.isExposedOnAllTransports = isExposedOnAllTransports;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Set getUsers() {
        return this.users;
    }

    public Set getPolicies() {
        return this.policies;
    }

    public void setPolicies(Set policies) {
        this.policies = policies;
    }

    public Set getOperations() {
        return this.operations;
    }

    public OperationDO[] getOperation(String operationName) {
        Iterator iter = this.operations.iterator();
        while (iter.hasNext()) {
            OperationDO opDO = (OperationDO)iter.next();
            if (!opDO.getName().equals(operationName)) continue;
            return new OperationDO[]{opDO};
        }
        return new OperationDO[0];
    }

    public void setOperations(Set operations) {
        this.operations = operations;
    }

    public void setUsers(Set users) {
        this.users = users;
    }

    public Set getParameters() {
        return this.parameters;
    }

    public ServiceParameterDO getParameter(String paramName) {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ServiceParameterDO serviceGroupParameterDO = (ServiceParameterDO)iterator.next();
            if (!serviceGroupParameterDO.getName().equals(paramName)) continue;
            return serviceGroupParameterDO;
        }
        return null;
    }

    public void setParameters(Set parameters) {
        this.parameters = parameters;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public Set getTransports() {
        return this.transports;
    }

    public void setTransports(Set transports) {
        this.transports = transports;
    }

    public KeyStoreDO getPrivateKeyStore() {
        return this.privateKeyStore;
    }

    public void setPrivateKeyStore(KeyStoreDO privateKeyStore) {
        if (this.privateKeyStore != null && privateKeyStore == null) {
            this.privateKeyStore.getPkStoreServices().remove(this);
        }
        this.privateKeyStore = privateKeyStore;
    }

    public Set getTrustedCertStores() {
        return this.trustedCertStores;
    }

    public void setTrustedCertStores(Set trustedCertStores) {
        this.trustedCertStores = trustedCertStores;
    }

    public void addRole(ServiceUserRoleDO role) {
        this.roles.add(role);
        role.getServices().add(this);
    }

    public void addTrustedCertStore(KeyStoreDO keyStore) {
        if (!this.trustedCertStores.contains(keyStore)) {
            this.trustedCertStores.add(keyStore);
            keyStore.getTrustStoreServices().add(this);
        }
    }

    public void removeAllTrustedCertStores() {
        Iterator iter = this.trustedCertStores.iterator();
        while (iter.hasNext()) {
            KeyStoreDO keyStoreDO = (KeyStoreDO)iter.next();
            keyStoreDO.getTrustStoreServices().remove(this);
        }
        this.trustedCertStores.clear();
    }

    public void removeAllUsers() {
        Iterator iter = this.users.iterator();
        while (iter.hasNext()) {
            ServiceUserDO userDO = (ServiceUserDO)iter.next();
            userDO.getServices().remove(this);
        }
        this.users.clear();
    }

    public void removeAllRoles() {
        Iterator iter = this.roles.iterator();
        while (iter.hasNext()) {
            ServiceUserRoleDO roleDO = (ServiceUserRoleDO)iter.next();
            roleDO.getServices().remove(this);
        }
        this.roles.clear();
    }

    public void removeAllTransports() {
        Iterator iter = this.transports.iterator();
        while (iter.hasNext()) {
            TransportDO transportDO = (TransportDO)iter.next();
            transportDO.getServices().remove(this);
        }
        this.transports.clear();
    }

    public void removeSecurityScenario() {
        if (this.securityScenario != null) {
            this.securityScenario.getServices().remove(this);
            this.securityScenario = null;
        }
    }

    public void removeAllRelationships() {
        this.removeAllRoles();
        this.removeAllTransports();
        this.removeAllTrustedCertStores();
        this.removeAllUsers();
        this.removeSecurityScenario();
    }

    public void addParameter(ServiceParameterDO param) {
        this.parameters.add(param);
        param.setService(this);
    }

    public void addUser(ServiceUserDO serviceUser) {
        this.users.add(serviceUser);
        serviceUser.getServices().add(this);
    }

    public void addPolicy(ServicePolicyDO policy) {
        this.policies.add(policy);
        policy.setService(this);
    }

    public void addOperation(OperationDO operation) {
        this.operations.add(operation);
        operation.setService(this);
    }

    public void addEngagedModule(ModuleDO module) {
        this.engagedModules.add(module);
        module.getEngagedServices().add(this);
    }

    public void addTransport(TransportDO transport) {
        if (transport != null) {
            this.transports.add(transport);
            transport.getServices().add(this);
        }
    }

    public void addTrustStore(KeyStoreDO trustStore) {
        this.trustedCertStores.add(trustStore);
    }

    public Set getEngagedModules() {
        return this.engagedModules;
    }

    public void setEngagedModules(Set engagedModules) {
        this.engagedModules = engagedModules;
    }

    public ServiceGroupDO getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(ServiceGroupDO serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public SecurityScenarioDO getSecurityScenario() {
        return this.securityScenario;
    }

    public void setSecurityScenario(SecurityScenarioDO securityScenario) {
        this.securityScenario = securityScenario;
    }

    public int hashCode() {
        if (this.serviceIdentifierDO != null) {
            return this.serviceIdentifierDO.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceDO) {
            ServiceDO serviceDO = (ServiceDO)obj;
            if (this.serviceIdentifierDO != null) {
                return this.serviceIdentifierDO.equals(serviceDO.getServiceIdentifierDO());
            }
        }
        return false;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

