/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dataobject;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.SecurityTokenPropertyDO;

public class SecurityTokenDO
extends AbstractDataObject {
    private String tokenId;
    private int state = -1;
    private String tokenStr;
    private String previousTokenStr;
    private String attachedReferenceStr;
    private String unattachedReferenceStr;
    private String secretStr;
    private Date created;
    private Date expires;
    private Set securityTokenProperties = new HashSet();

    public SecurityTokenDO() {
    }

    public SecurityTokenDO(String id, OMElement token, Date created, Date expires) {
        this.tokenId = id;
        this.created = created;
        this.expires = expires;
        this.tokenStr = token.toString();
    }

    public Token toToken() throws TrustException {
        Token token;
        try {
            token = new Token(this.tokenId, this.toOMElement(this.tokenStr), this.created, this.expires);
            token.setAttachedReference(this.toOMElement(this.attachedReferenceStr));
            token.setUnattachedReference(this.toOMElement(this.unattachedReferenceStr));
            token.setPreviousToken(this.toOMElement(this.previousTokenStr));
            token.setState(this.state);
            token.setSecret(Base64.decode((String)this.secretStr));
            Properties tokenProps = new Properties();
            Iterator iterator = this.securityTokenProperties.iterator();
            while (iterator.hasNext()) {
                SecurityTokenPropertyDO prop = (SecurityTokenPropertyDO)iterator.next();
                tokenProps.setProperty(prop.getName(), prop.getValue());
            }
            token.setProperties(tokenProps);
        }
        catch (XMLStreamException e) {
            throw new TrustException("Could not construct token from TokenDO", (Throwable)e);
        }
        return token;
    }

    private OMElement toOMElement(String serializedEle) throws XMLStreamException {
        if (serializedEle == null) {
            return null;
        }
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(serializedEle.getBytes()));
        StAXOMBuilder builder = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), reader);
        return builder.getDocumentElement();
    }

    public void update(Token token) {
        this.tokenStr = token.getToken().toString();
        this.previousTokenStr = token.getPreviousToken() != null ? token.getPreviousToken().toString() : null;
        this.unattachedReferenceStr = token.getUnattachedReference() != null ? token.getUnattachedReference().toString() : null;
        this.attachedReferenceStr = token.getAttachedReference() != null ? token.getAttachedReference().toString() : null;
        this.secretStr = Base64.encode((byte[])token.getSecret());
        this.setExpires(token.getExpires());
        this.setState(token.getState());
        Properties tokenProps = token.getProperties();
        if (tokenProps != null) {
            Iterator<Object> iter = tokenProps.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                SecurityTokenPropertyDO prop = new SecurityTokenPropertyDO(key, tokenProps.getProperty(key));
                this.addProperty(prop);
            }
        }
    }

    public String getTokenStr() {
        return this.tokenStr;
    }

    public void setTokenStr(String tokenStr) {
        this.tokenStr = tokenStr;
    }

    public String getSecretStr() {
        return this.secretStr;
    }

    public void setSecretStr(String secretStr) {
        this.secretStr = secretStr;
    }

    public String getPreviousTokenStr() {
        return this.previousTokenStr;
    }

    public void setPreviousTokenStr(String previousTokenStr) {
        this.previousTokenStr = previousTokenStr;
    }

    public String getAttachedReferenceStr() {
        return this.attachedReferenceStr;
    }

    public void setAttachedReferenceStr(String attachedReferenceStr) {
        this.attachedReferenceStr = attachedReferenceStr;
    }

    public String getUnattachedReferenceStr() {
        return this.unattachedReferenceStr;
    }

    public void setUnattachedReferenceStr(String unattachedReferenceStr) {
        this.unattachedReferenceStr = unattachedReferenceStr;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Set getSecurityTokenProperties() {
        return this.securityTokenProperties;
    }

    public void setSecurityTokenProperties(Set securityTokenProperties) {
        this.securityTokenProperties = securityTokenProperties;
    }

    public void addProperty(SecurityTokenPropertyDO prop) {
        if (!this.securityTokenProperties.contains(prop)) {
            this.securityTokenProperties.add(prop);
            prop.setToken(this);
        } else {
            Iterator iter = this.securityTokenProperties.iterator();
            while (iter.hasNext()) {
                SecurityTokenPropertyDO oldPropDO = (SecurityTokenPropertyDO)iter.next();
                if (!oldPropDO.getName().equals(prop.getName())) continue;
                oldPropDO.setValue(prop.getValue());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityTokenDO that = (SecurityTokenDO)o;
        return this.tokenId.equals(that.tokenId);
    }

    public int hashCode() {
        return this.tokenId.hashCode();
    }
}

