/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.util.HibernateConfig;

public class UserRoleDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)UserRoleDAO.class);

    public UserRoleDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public ServiceUserRoleDO[] getUserRoles() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserRoleDO[] roles = new ServiceUserRoleDO[]{};
        try {
            Criteria roleCriteria = session.createCriteria(ServiceUserRoleDO.class);
            List list = roleCriteria.list();
            roles = list.toArray(new ServiceUserRoleDO[list.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve user roles";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return roles;
    }

    public ServiceUserRoleDO getUserRole(String role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserRoleDO serviceUserRoleDO = null;
        try {
            Criteria roleCriteria = session.createCriteria(ServiceUserRoleDO.class);
            roleCriteria.add((Criterion)Expression.eq((String)"role", (Object)role.trim()));
            serviceUserRoleDO = (ServiceUserRoleDO)roleCriteria.uniqueResult();
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve user role";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return serviceUserRoleDO;
    }

    public void deleteRole(String role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria roleCriteria = session.createCriteria(ServiceUserRoleDO.class);
            roleCriteria.add((Criterion)Expression.eq((String)"role", (Object)role.trim()));
            ServiceUserRoleDO serviceUserRoleDO = (ServiceUserRoleDO)roleCriteria.uniqueResult();
            if (serviceUserRoleDO == null) {
                tx.rollback();
                return;
            }
            Set users = serviceUserRoleDO.getUsers();
            Set services = serviceUserRoleDO.getServices();
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                ServiceDO service = (ServiceDO)iterator.next();
                service.getRoles().remove(serviceUserRoleDO);
                session.update((Object)service);
            }
            iterator = users.iterator();
            while (iterator.hasNext()) {
                ServiceUserDO user = (ServiceUserDO)iterator.next();
                user.getRoles().remove(serviceUserRoleDO);
                session.update((Object)user);
            }
            session.delete((Object)serviceUserRoleDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to delete role";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }
}

