/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.util.HibernateConfig;

public class UserDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)UserDAO.class);

    public UserDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public ServiceUserDO[] getUsers() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserDO[] users = new ServiceUserDO[]{};
        try {
            Criteria userCriteria = session.createCriteria(ServiceUserDO.class);
            List list = userCriteria.list();
            users = list.toArray(new ServiceUserDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve all users";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return users;
    }

    public void deleteUser(String username) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria userCriteria = session.createCriteria(ServiceUserDO.class);
            userCriteria.add((Criterion)Expression.eq((String)"username", (Object)username));
            ServiceUserDO user = (ServiceUserDO)userCriteria.uniqueResult();
            if (user == null) {
                tx.rollback();
                return;
            }
            Set services = user.getServices();
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                ServiceDO service = (ServiceDO)iterator.next();
                if (service.getUsers().size() == 1) {
                    service.setIsUTAuthEnabled(false);
                }
                service.getUsers().remove(user);
                session.update((Object)service);
            }
            session.delete((Object)user);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            tx.rollback();
            String msg = "Unable to deleteUser";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void deleteRoleFromUser(String username, String role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria userCriteria = session.createCriteria(ServiceUserDO.class);
            userCriteria.add((Criterion)Expression.eq((String)"username", (Object)username));
            ServiceUserDO userDO = (ServiceUserDO)userCriteria.uniqueResult();
            if (userDO == null) {
                tx.rollback();
                return;
            }
            Criteria roleCriteria = session.createCriteria(ServiceUserRoleDO.class);
            roleCriteria.add((Criterion)Expression.eq((String)"role", (Object)role));
            ServiceUserRoleDO roleDO = (ServiceUserRoleDO)roleCriteria.uniqueResult();
            if (roleDO == null) {
                tx.rollback();
                return;
            }
            Set roles = userDO.getRoles();
            if (roles.contains(roleDO)) {
                userDO.getRoles().remove(roleDO);
                session.update((Object)userDO);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to remove role from user";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public ServiceUserDO getUser(String username) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserDO user = null;
        try {
            Criteria userCriteria = session.createCriteria(ServiceUserDO.class);
            userCriteria.add((Criterion)Expression.eq((String)"username", (Object)username));
            user = (ServiceUserDO)userCriteria.uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve user";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return user;
    }

    public ServiceUserRoleDO[] getUserRoles(ServiceUserDO serviceUserDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserRoleDO[] serviceUserRoleDOs = null;
        try {
            Set roles = serviceUserDO.getRoles();
            serviceUserRoleDOs = roles.toArray(new ServiceUserRoleDO[roles.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get roles";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            session.evict((Object)serviceUserDO);
            this.hbConfig.closeSession();
        }
        return serviceUserRoleDOs;
    }

    public void addRole(String userName, ServiceUserRoleDO role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserDO userDO = null;
        try {
            userDO = this.getUser(userName, session);
            role = (ServiceUserRoleDO)session.load(ServiceUserRoleDO.class, (Serializable)role.getId());
            if (!userDO.getRoles().contains(role)) {
                userDO.addRole(role);
                session.update((Object)userDO);
                session.update((Object)role);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            String msg = "Unable to add role";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            session.evict((Object)userDO);
            this.hbConfig.closeSession();
        }
    }

    public ServiceUserDO getUser(String username, Session session) {
        Criteria userCriteria = session.createCriteria(ServiceUserDO.class);
        userCriteria.add((Criterion)Expression.eq((String)"username", (Object)username));
        return (ServiceUserDO)userCriteria.uniqueResult();
    }

    public ServiceUserRoleDO[] getRoles(String serviceUser) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceUserDO serviceUserDO = null;
        ServiceUserRoleDO[] serviceUserRoleDOs = null;
        try {
            serviceUserDO = this.getUser(serviceUser, session);
            if (serviceUserDO != null) {
                Set roles = serviceUserDO.getRoles();
                serviceUserRoleDOs = roles.toArray(new ServiceUserRoleDO[roles.size()]);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get roles";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            session.evict((Object)serviceUserDO);
            this.hbConfig.closeSession();
        }
        return serviceUserRoleDOs;
    }

    public boolean userHasRole(String username, ServiceUserRoleDO role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        boolean containsRole = false;
        try {
            containsRole = this.getUser(username, session).getRoles().contains(role);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get roles";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return containsRole;
    }
}

