/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.util.HibernateConfig;

public class TransportDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)TransportDAO.class);

    public TransportDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public TransportDO[] getTransports() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        TransportDO[] transports = new TransportDO[]{};
        try {
            Criteria transportCriteria = session.createCriteria(TransportDO.class);
            List list = transportCriteria.list();
            transports = list.toArray(new TransportDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Transports";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return transports;
    }

    public TransportDO getTransport(String protocol) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        TransportDO transport = null;
        try {
            Criteria transportCriteria = session.createCriteria(TransportDO.class);
            transportCriteria.add((Criterion)Expression.eq((String)"transportProtocol", (Object)protocol.trim()));
            transport = (TransportDO)transportCriteria.uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Transport";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return transport;
    }

    public TransportDO getTransport(String protocol, Session session) {
        Criteria transportCriteria = session.createCriteria(TransportDO.class);
        transportCriteria.add((Criterion)Expression.eq((String)"transportProtocol", (Object)protocol.trim()));
        return (TransportDO)transportCriteria.uniqueResult();
    }

    public void delete(TransportDO transport) {
    }
}

