/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dao.ServiceDAO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupParameterDO;
import org.wso2.wsas.persistence.exception.ServiceGroupNotFoundException;
import org.wso2.wsas.util.HibernateConfig;

public class ServiceGroupDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)ServiceGroupDAO.class);

    public ServiceGroupDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long createServiceGroup(ServiceGroupDO trasientInstance) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            trasientInstance.setLastUpdatedTime(new Date());
            session.persist((Object)trasientInstance);
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return trasientInstance.getId();
    }

    public Long createServiceGroup(ServiceGroupDO trasientInstance, Session session) {
        trasientInstance.setLastUpdatedTime(new Date());
        session.persist((Object)trasientInstance);
        session.flush();
        return trasientInstance.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceGroupDO getServiceGroup(String serviceGroupId) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceGroupDO serviceGroupDO = null;
        try {
            Criteria criteria = session.createCriteria(ServiceGroupDO.class);
            criteria.add((Criterion)Expression.eq((String)"name", (Object)serviceGroupId.trim()));
            serviceGroupDO = (ServiceGroupDO)criteria.uniqueResult();
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return serviceGroupDO;
    }

    public ServiceGroupDO getServiceGroup(String serviceGroupId, Session session) {
        Criteria criteria = session.createCriteria(ServiceGroupDO.class);
        criteria.add((Criterion)Expression.eq((String)"name", (Object)serviceGroupId.trim()));
        return (ServiceGroupDO)criteria.uniqueResult();
    }

    public ServiceGroupParameterDO getParameter(ServiceGroupDO serviceGroup, String paramName) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceGroupParameterDO paramDO = null;
        try {
            Criteria criteria = session.createCriteria(ServiceGroupParameterDO.class, "param").createAlias("param.serviceGroup", "sg").add((Criterion)Expression.eq((String)"name", (Object)paramName.trim())).add((Criterion)Expression.eq((String)"sg.name", (Object)serviceGroup.getName()));
            paramDO = (ServiceGroupParameterDO)criteria.uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to getParameter";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(paramDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)paramDO);
        this.hbConfig.closeSession();
        return paramDO;
    }

    public ServiceDO[] getServices(ServiceGroupDO serviceGroup) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO[] serviceDOs = null;
        try {
            serviceDOs = this.getServices(serviceGroup, session);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get service operations";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return serviceDOs;
    }

    public ServiceDO[] getServices(ServiceGroupDO serviceGroup, Session session) {
        ServiceGroupDO serviceGroupDO = (ServiceGroupDO)session.load(ServiceGroupDO.class, (Serializable)serviceGroup.getId());
        Set serviceSet = serviceGroupDO.getServices();
        return serviceSet.toArray(new ServiceDO[serviceSet.size()]);
    }

    public void deleteServiceGroup(String serviceGroupName) throws ServiceGroupNotFoundException {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceGroupDO serviceGroupDO = this.getServiceGroup(serviceGroupName, session);
        if (serviceGroupDO == null) {
            String msg = "Service group " + serviceGroupName + " not found";
            log.error((Object)msg);
            throw new ServiceGroupNotFoundException(msg);
        }
        ServiceDO[] serviceDOs = this.getServices(serviceGroupDO, session);
        ServiceDAO serviceDAO = new ServiceDAO(this.hbConfig);
        try {
            for (int i = 0; i < serviceDOs.length; ++i) {
                serviceDAO.deleteService(serviceDOs[i], session);
            }
            session.delete((Object)serviceGroupDO);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to delete service group " + serviceGroupName;
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }
}

