/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Restrictions;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ServiceParameterDO;
import org.wso2.wsas.persistence.dataobject.ServicePolicyDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.exception.ServicePolicyNotFoundException;
import org.wso2.wsas.util.HibernateConfig;

public class ServiceDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)ServiceDAO.class);

    public ServiceDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public void updateService(ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            service.setLastUpdatedTime(new Date());
            session.merge((Object)service);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to update service";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public ServiceDO getService(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getService";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return serviceDO;
    }

    public void addOperation(String serviceId, String version, OperationDO op) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            service.addOperation(op);
            session.update((Object)service);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to add operation";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public OperationDO[] getOperations(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        OperationDO[] opDOs = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            Set opSet = serviceDO.getOperations();
            opDOs = opSet.toArray(new OperationDO[opSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get service operations";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return opDOs;
    }

    public OperationDO[] getOperations(ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        OperationDO[] opDOs = null;
        try {
            serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)service.getId());
            Set opSet = serviceDO.getOperations();
            opDOs = opSet.toArray(new OperationDO[opSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get service operations";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return opDOs;
    }

    public void addUser(String serviceId, String version, ServiceUserDO user) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            user = this.getUser(user.getUsername(), session);
            service.setIsUTAuthEnabled(true);
            if (!service.getUsers().contains(user)) {
                service.addUser(user);
                session.update((Object)user);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to addUser";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public void addRole(String serviceId, String version, ServiceUserRoleDO role) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            role = this.getRole(role.getRole(), session);
            service.setIsUTAuthEnabled(true);
            if (!service.getRoles().contains(role)) {
                service.addRole(role);
                session.update((Object)role);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to addRole";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public ServiceUserRoleDO getRole(String roleName, Session session) {
        Criteria criteria = session.createCriteria(ServiceUserRoleDO.class);
        criteria.add((Criterion)Expression.eq((String)"role", (Object)roleName.trim()));
        return (ServiceUserRoleDO)criteria.uniqueResult();
    }

    private ServiceUserDO getUser(String username, Session session) {
        Criteria criteria = session.createCriteria(ServiceUserDO.class);
        criteria.add((Criterion)Expression.eq((String)"username", (Object)username.trim()));
        return (ServiceUserDO)criteria.uniqueResult();
    }

    public void addPolicy(String serviceId, String version, ServicePolicyDO policy) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            if (!service.getPolicies().contains(policy)) {
                service.addPolicy(policy);
                session.update((Object)service);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to addPolicy";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public void updatePolicy(ServicePolicyDO servicePolicy) throws ServicePolicyNotFoundException {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria criteria = session.createCriteria(ServicePolicyDO.class, "policy").createAlias("policy.service", "s").add((Criterion)Restrictions.eq((String)"policy.uuid", (Object)servicePolicy.getUuid())).add((Criterion)Restrictions.eq((String)"s.serviceIdentifierDO.serviceId", (Object)servicePolicy.getService().getServiceIdentifierDO().getServiceId().trim())).add((Criterion)Restrictions.eq((String)"s.serviceIdentifierDO.version", (Object)servicePolicy.getService().getServiceIdentifierDO().getVersion().trim()));
            ServicePolicyDO origServicePolicy = (ServicePolicyDO)criteria.uniqueResult();
            if (origServicePolicy == null) {
                session.save((Object)servicePolicy);
            } else {
                origServicePolicy.setPolicy(servicePolicy.getPolicy());
                session.update((Object)origServicePolicy);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to update service policy";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void addParameter(String serviceId, String version, ServiceParameterDO param) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            if (!service.getParameters().contains(param)) {
                service.addParameter(param);
                session.update((Object)service);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to add parameter";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public ServiceUserDO[] getUsers(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServiceUserDO[] userDOs = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            Set userSet = serviceDO.getUsers();
            userDOs = userSet.toArray(new ServiceUserDO[userSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get service users";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return userDOs;
    }

    public ServiceUserRoleDO[] getRoles(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServiceUserRoleDO[] userRoleDOs = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            Set roleSet = serviceDO.getRoles();
            userRoleDOs = roleSet.toArray(new ServiceUserRoleDO[roleSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get roles";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return userRoleDOs;
    }

    public ServicePolicyDO[] getPolicies(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServicePolicyDO[] policyDOs = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            Set opSet = serviceDO.getPolicies();
            policyDOs = opSet.toArray(new ServicePolicyDO[opSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get policies";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return policyDOs;
    }

    public ServicePolicyDO[] getPolicies(ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServicePolicyDO[] policyDOs = null;
        try {
            serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)service.getId());
            Set opSet = serviceDO.getPolicies();
            policyDOs = opSet.toArray(new ServicePolicyDO[opSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get policies";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return policyDOs;
    }

    public ServiceParameterDO[] getParameters(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServiceParameterDO[] paramDOs = null;
        try {
            serviceDO = this.getService(serviceId, version, session);
            Set opSet = serviceDO.getParameters();
            paramDOs = opSet.toArray(new ServiceParameterDO[opSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get parameters";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return paramDOs;
    }

    public ServiceParameterDO[] getParameters(ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO serviceDO = null;
        ServiceParameterDO[] paramDOs = null;
        try {
            serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)service.getId());
            Set paramSet = serviceDO.getParameters();
            paramDOs = paramSet.toArray(new ServiceParameterDO[paramSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to get parameters";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(serviceDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)serviceDO);
        this.hbConfig.closeSession();
        return paramDOs;
    }

    public ServiceParameterDO getParameter(ServiceDO service, String paramName) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        Object serviceDO = null;
        ServiceParameterDO paramDO = null;
        try {
            ServiceIdentifierDO sid = service.getServiceIdentifierDO();
            Criteria criteria = session.createCriteria(ServiceParameterDO.class, "param").createAlias("param.service", "s").add((Criterion)Expression.eq((String)"name", (Object)paramName.trim())).add((Criterion)Expression.eq((String)"s.serviceIdentifierDO.serviceId", (Object)sid.getServiceId().trim())).add((Criterion)Expression.eq((String)"s.serviceIdentifierDO.version", (Object)sid.getVersion().trim()));
            paramDO = (ServiceParameterDO)criteria.uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get parameter";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            session.evict(serviceDO);
            this.hbConfig.closeSession();
        }
        return paramDO;
    }

    public void deleteService(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            this.deleteService(serviceId, version, session);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to deleteService";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void deleteService(String serviceId, String version, Session session) {
        ServiceDO serviceDO = this.getService(serviceId, version, session);
        KeyStoreDO privateKeyStore = serviceDO.getPrivateKeyStore();
        if (privateKeyStore != null) {
            privateKeyStore.getPkStoreServices().remove(serviceDO);
            serviceDO.setPrivateKeyStore(null);
            session.update((Object)privateKeyStore);
        }
        Iterator iter = serviceDO.getTrustedCertStores().iterator();
        while (iter.hasNext()) {
            KeyStoreDO keyStoreDO = (KeyStoreDO)iter.next();
            keyStoreDO.getTrustStoreServices().remove(serviceDO);
        }
        serviceDO.removeAllRelationships();
        session.update((Object)serviceDO);
        session.delete((Object)serviceDO);
    }

    public void deleteService(ServiceDO serviceDO, Session session) {
        KeyStoreDO privateKeyStore = serviceDO.getPrivateKeyStore();
        if (privateKeyStore != null) {
            privateKeyStore.getPkStoreServices().remove(serviceDO);
            serviceDO.setPrivateKeyStore(null);
            session.update((Object)privateKeyStore);
        }
        Iterator iter = serviceDO.getTrustedCertStores().iterator();
        while (iter.hasNext()) {
            KeyStoreDO keyStoreDO = (KeyStoreDO)iter.next();
            keyStoreDO.getTrustStoreServices().remove(serviceDO);
        }
        serviceDO.removeAllRelationships();
        session.update((Object)serviceDO);
        session.delete((Object)serviceDO);
    }

    public ModuleDO[] getEngagedModules(String serviceId, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO[] modules = new ModuleDO[]{};
        try {
            ServiceDO serviceDO = this.getService(serviceId, version, session);
            Set engagedModules = serviceDO.getEngagedModules();
            modules = engagedModules.toArray(new ModuleDO[engagedModules.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to deleteService";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return modules;
    }

    public ModuleDO[] getEngagedModules(ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO[] modules = new ModuleDO[]{};
        try {
            ServiceDO serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)service.getId());
            Set engagedModules = serviceDO.getEngagedModules();
            modules = engagedModules.toArray(new ModuleDO[engagedModules.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to deleteService";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return modules;
    }

    private ServiceDO getService(String serviceId, String version, Session session) {
        Criteria criteria = session.createCriteria(ServiceDO.class);
        criteria.add((Criterion)Expression.eq((String)"serviceIdentifierDO.serviceId", (Object)serviceId.trim()));
        criteria.add((Criterion)Expression.eq((String)"serviceIdentifierDO.version", (Object)version.trim()));
        return (ServiceDO)criteria.uniqueResult();
    }

    public void removeServiceUser(String serviceId, String version, ServiceUserDO user, AxisService axisService) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            user = this.getUser(user.getUsername(), session);
            if (service.getUsers().contains(user)) {
                user.getServices().remove(service);
                service.getUsers().remove(user);
                session.update((Object)user);
            }
            this.checkUTAuthenticationDisablingNeeded(service, axisService);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to remove user from service";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    public void removeServiceRole(String serviceId, String version, ServiceUserRoleDO role, AxisService axisService) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = this.getService(serviceId, version, session);
            role = this.getRole(role.getRole(), session);
            if (service.getRoles().contains(role)) {
                role.getServices().remove(service);
                service.getRoles().remove(role);
                session.update((Object)role);
            }
            this.checkUTAuthenticationDisablingNeeded(service, axisService);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to remove role from service";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }

    private void checkUTAuthenticationDisablingNeeded(ServiceDO service, AxisService axisService) throws AxisFault {
        if (service.getUsers().isEmpty() && service.getRoles().isEmpty()) {
            service.setIsUTAuthEnabled(false);
            axisService.removeParameter(new Parameter("InflowSecurity", null));
            axisService.removeParameter(new Parameter("passwordCallbackRef", null));
        }
    }

    public void removeAllTrustedCertStores(ServiceDO serviceDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceDO service = null;
        try {
            service = (ServiceDO)session.load(ServiceDO.class, (Serializable)serviceDO.getId());
            Iterator iter = service.getTrustedCertStores().iterator();
            while (iter.hasNext()) {
                KeyStoreDO keyStoreDO = (KeyStoreDO)iter.next();
                keyStoreDO.getTrustStoreServices().remove(service);
                session.update((Object)keyStoreDO);
            }
            service.removeAllTrustedCertStores();
            session.update((Object)service);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to remove all TrustedCertStores from service";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(service);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)service);
        this.hbConfig.closeSession();
    }
}

