/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.ServerConfigurationDO;
import org.wso2.wsas.util.HibernateConfig;

public class ServerConfigurationDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)ServerConfigurationDAO.class);

    public ServerConfigurationDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public String getConfigurationProperty(String propertyName) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        String value = null;
        try {
            Criteria criteria = session.createCriteria(ServerConfigurationDO.class);
            criteria.add((Criterion)Expression.eq((String)"name", (Object)propertyName.trim()));
            ServerConfigurationDO serverConfig = (ServerConfigurationDO)criteria.uniqueResult();
            if (serverConfig != null) {
                value = serverConfig.getValue();
            }
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getConfigurationProperty";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return value;
    }

    public void updateConfigurationProperty(String propertyName, String value) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            return;
        }
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria criteria = session.createCriteria(ServerConfigurationDO.class);
            criteria.add((Criterion)Expression.eq((String)"name", (Object)propertyName.trim()));
            ServerConfigurationDO serverConfig = (ServerConfigurationDO)criteria.uniqueResult();
            if (serverConfig != null) {
                serverConfig.setValue(value);
            } else {
                serverConfig = new ServerConfigurationDO();
                serverConfig.setName(propertyName);
                serverConfig.setValue(value);
                session.save((Object)serverConfig);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to updateConfigurationProperty";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }
}

