/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.SecurityTokenDO;
import org.wso2.wsas.util.HibernateConfig;

public class SecurityTokenDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)SecurityTokenDAO.class);

    public SecurityTokenDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public SecurityTokenDO getToken(String tokenId) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        SecurityTokenDO token = null;
        try {
            Criteria criteria = session.createCriteria(SecurityTokenDO.class);
            criteria.add((Criterion)Expression.eq((String)"tokenId", (Object)tokenId.trim()));
            token = (SecurityTokenDO)criteria.uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get Token";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return token;
    }

    public SecurityTokenDO[] getAllTokens() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        SecurityTokenDO[] tokens = new SecurityTokenDO[]{};
        try {
            Criteria criteria = session.createCriteria(SecurityTokenDO.class);
            List list = criteria.list();
            tokens = list.toArray(new SecurityTokenDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get all Tokens";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return tokens;
    }
}

