/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.util.HibernateConfig;

public class SecurityScenarioDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)SecurityScenarioDAO.class);

    public SecurityScenarioDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public SecurityScenarioDO[] getAllScenarios() {
        Session session = this.hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        List scenarios = new ArrayList();
        try {
            Criteria criteria = session.createCriteria(SecurityScenarioDO.class);
            scenarios = criteria.list();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to get all scenarios";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return scenarios.toArray(new SecurityScenarioDO[scenarios.size()]);
    }

    public SecurityScenarioDO getSecurityScenario(String scenarioId) {
        Session session = this.hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        SecurityScenarioDO scenario = null;
        try {
            Criteria criteria = session.createCriteria(SecurityScenarioDO.class);
            criteria.add((Criterion)Expression.eq((String)"scenarioId", (Object)scenarioId.trim()));
            scenario = (SecurityScenarioDO)criteria.uniqueResult();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to get all scenarios";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return scenario;
    }
}

