/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.OperationParameterDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.util.HibernateConfig;

public class OperationDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)OperationDAO.class);

    public OperationDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceIdentifierDO getServiceIdentifier(OperationDO op) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceIdentifierDO serviceId = null;
        try {
            op = (OperationDO)session.load(OperationDO.class, (Serializable)op.getId());
            ServiceDO service = op.getService();
            serviceId = service.getServiceIdentifierDO();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return serviceId;
    }

    public void updateOperation(OperationDO operation) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            operation.setLastUpdatedTime(new Date());
            session.merge((Object)operation);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to update service";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDO[] getEngagedModules(OperationDO op) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO[] modules = new ModuleDO[]{};
        try {
            op = (OperationDO)session.load(OperationDO.class, (Serializable)op.getId());
            Set engagedModules = op.getEngagedModules();
            modules = engagedModules.toArray(new ModuleDO[engagedModules.size()]);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationParameterDO[] getParameters(OperationDO op) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        OperationParameterDO[] params = new OperationParameterDO[]{};
        try {
            op = (OperationDO)session.load(OperationDO.class, (Serializable)op.getId());
            Set paramSet = op.getParameters();
            params = paramSet.toArray(new OperationParameterDO[paramSet.size()]);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationDO getOperation(String serviceId, String serviceVersion, String opName) {
        String query = "from OperationDO as op where op.service.serviceIdentifierDO.serviceId='" + serviceId.trim() + "' and op.service.serviceIdentifierDO.version='" + serviceVersion.trim() + "' and op.name='" + opName.trim() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        OperationDO op = null;
        try {
            op = (OperationDO)session.createQuery(query).uniqueResult();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationParameterDO getOperationParameter(String serviceId, String serviceVersion, String operationId, String paramName) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        OperationDO opDO = this.getOperation(serviceId, serviceVersion, operationId, session);
        OperationParameterDO opParamDO = null;
        try {
            Iterator iter = opDO.getParameters().iterator();
            while (iter.hasNext() && !(opParamDO = (OperationParameterDO)iter.next()).getName().equals(paramName)) {
            }
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.hbConfig.closeSession();
        }
        return opParamDO;
    }

    public OperationDO getOperation(String serviceId, String serviceVersion, String opName, Session session) {
        String query = "from OperationDO as op where op.service.serviceIdentifierDO.serviceId='" + serviceId.trim() + "' and op.service.serviceIdentifierDO.version='" + serviceVersion.trim() + "' and op.name='" + opName.trim() + "'";
        return (OperationDO)session.createQuery(query).uniqueResult();
    }
}

