/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.ModuleParameterDO;
import org.wso2.wsas.persistence.dataobject.ModulePolicyDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.exception.ModulePolicyNotFoundException;
import org.wso2.wsas.util.HibernateConfig;

public class ModuleDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)ModuleDAO.class);

    public ModuleDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public ModuleDO getModule(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getModule";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return moduleDO;
    }

    public void deleteModule(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            Set engagedOperations = moduleDO.getEngagedOperations();
            Iterator iterator = engagedOperations.iterator();
            while (iterator.hasNext()) {
                OperationDO op = (OperationDO)iterator.next();
                op.getEngagedModules().remove(moduleDO);
                session.saveOrUpdate((Object)op);
            }
            engagedOperations.clear();
            Set engagedServiceGroups = moduleDO.getEngagedServiceGroups();
            Iterator iterator2 = engagedServiceGroups.iterator();
            while (iterator2.hasNext()) {
                ServiceGroupDO sg = (ServiceGroupDO)iterator2.next();
                sg.getEngagedModules().remove(moduleDO);
                session.saveOrUpdate((Object)sg);
            }
            engagedServiceGroups.clear();
            Set engagedServices = moduleDO.getEngagedServices();
            Iterator iterator3 = engagedServices.iterator();
            while (iterator3.hasNext()) {
                ServiceDO service = (ServiceDO)iterator3.next();
                service.getEngagedModules().remove(moduleDO);
                session.saveOrUpdate((Object)service);
            }
            engagedServices.clear();
            session.delete((Object)moduleDO);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to deleteModule";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public void addEngagedService(String moduleName, String version, ServiceDO service) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            service = (ServiceDO)session.load(ServiceDO.class, (Serializable)service.getId());
            if (!moduleDO.getEngagedServices().contains(service)) {
                moduleDO.addService(service);
                session.update((Object)moduleDO);
                session.update((Object)service);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to addEngagedService";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public void removeEngagedService(String moduleName, String version, ServiceDO serviceDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            if (moduleDO != null) {
                serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)serviceDO.getId());
                if (moduleDO.getEngagedServices().contains(serviceDO)) {
                    serviceDO.getEngagedModules().remove(moduleDO);
                    session.update((Object)moduleDO);
                    session.update((Object)serviceDO);
                }
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to removeEngagedService";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public void addEngagedServiceGroup(String moduleName, String version, ServiceGroupDO serviceGroup) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            serviceGroup = (ServiceGroupDO)session.load(ServiceGroupDO.class, (Serializable)serviceGroup.getId());
            serviceGroup.addModule(moduleDO);
            session.update((Object)moduleDO);
            session.update((Object)serviceGroup);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to addEngagedServiceGroup";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public void removeEngagedServiceGroup(String moduleName, String version, ServiceGroupDO serviceGrp) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            if (moduleDO != null) {
                serviceGrp = (ServiceGroupDO)session.load(ServiceGroupDO.class, (Serializable)serviceGrp.getId());
                if (moduleDO.getEngagedServiceGroups().contains(serviceGrp)) {
                    serviceGrp.getEngagedModules().remove(moduleDO);
                    session.update((Object)moduleDO);
                    session.update((Object)serviceGrp);
                }
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to removeEngagedService group";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public ServiceDO[] getEngagedServices(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        ServiceDO[] serviceDOs = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            Set engServiceSet = moduleDO.getEngagedServices();
            serviceDOs = engServiceSet.toArray(new ServiceDO[engServiceSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to getEngagedServices";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
        return serviceDOs;
    }

    public ServiceGroupDO[] getEngagedServiceGroups(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        ServiceGroupDO[] serviceGroupDOs = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            Set engServiceGroupSet = moduleDO.getEngagedServiceGroups();
            serviceGroupDOs = engServiceGroupSet.toArray(new ServiceGroupDO[engServiceGroupSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to getEngagedServices";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
        return serviceGroupDOs;
    }

    public void addEngagedOperation(String moduleName, String version, OperationDO operation) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            operation = (OperationDO)session.load(OperationDO.class, (Serializable)operation.getId());
            if (!moduleDO.getEngagedOperations().contains(operation)) {
                moduleDO.addOperation(operation);
                session.update((Object)moduleDO);
                session.update((Object)operation);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addEngagedOperation";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void removeEngagedOperation(String moduleName, String version, OperationDO operation) {
        if (operation == null) {
            return;
        }
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO moduleDO = null;
        try {
            moduleDO = this.getModule(moduleName, version, session);
            if (moduleDO != null) {
                operation = (OperationDO)session.load(OperationDO.class, (Serializable)operation.getId());
                if (moduleDO.getEngagedOperations().contains(operation)) {
                    operation.getEngagedModules().remove(moduleDO);
                    session.update((Object)moduleDO);
                    session.update((Object)operation);
                }
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                tx.rollback();
                String msg = "Unable to removeEngagedOperation";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                session.evict(moduleDO);
                this.hbConfig.closeSession();
                throw throwable;
            }
        }
        session.evict((Object)moduleDO);
        this.hbConfig.closeSession();
    }

    public void addPolicy(String moduleName, String version, ModulePolicyDO policy) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            policy.setModule(moduleDO);
            session.save((Object)policy);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addPolicy";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public OperationDO[] getEngagedOperations(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        OperationDO[] opDOs = null;
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            Set engOpSet = moduleDO.getEngagedOperations();
            opDOs = engOpSet.toArray(new OperationDO[engOpSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getEngagedOperations";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return opDOs;
    }

    public ModulePolicyDO[] getPolicies(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModulePolicyDO[] policies = null;
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            Set policySet = moduleDO.getPolicies();
            policies = policySet.toArray(new ModulePolicyDO[policySet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getPolicies";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return policies;
    }

    public ModulePolicyDO[] getPolicies(ModuleDO module) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModulePolicyDO[] policies = null;
        try {
            ModuleDO moduleDO = (ModuleDO)session.load(ModuleDO.class, (Serializable)module.getId());
            Set policySet = moduleDO.getPolicies();
            policies = policySet.toArray(new ModulePolicyDO[policySet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getPolicies";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return policies;
    }

    public void updatePolicy(ModulePolicyDO modulePolicy) throws ModulePolicyNotFoundException {
        String query = "from ModulePolicyDO as policy where uuid='" + modulePolicy.getUuid() + "' and " + "policy.module.moduleIdentifierDO.name='" + modulePolicy.getModule().getModuleIdentifierDO().getName() + "' and " + "policy.module.moduleIdentifierDO.version='" + modulePolicy.getModule().getModuleIdentifierDO().getVersion() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            ModulePolicyDO origModulePolicy = (ModulePolicyDO)session.createQuery(query).uniqueResult();
            if (origModulePolicy == null) {
                throw new ModulePolicyNotFoundException("Module Policy with UUID " + modulePolicy.getUuid() + " not found");
            }
            origModulePolicy.setPolicy(modulePolicy.getPolicy());
            session.update((Object)origModulePolicy);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to updatePolicy";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void addParameter(String moduleName, String version, ModuleParameterDO param) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            param.setModule(moduleDO);
            session.save((Object)param);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addParameter";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public ModuleParameterDO[] getParameters(String moduleName, String version) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleParameterDO[] params = null;
        try {
            ModuleDO moduleDO = this.getModule(moduleName, version, session);
            Set paramSet = moduleDO.getParameters();
            params = paramSet.toArray(new ModuleParameterDO[paramSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getParameters";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return params;
    }

    public ModuleParameterDO[] getParameters(ModuleDO module) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleParameterDO[] params = null;
        try {
            ModuleDO moduleDO = (ModuleDO)session.load(ModuleDO.class, (Serializable)module.getId());
            Set paramSet = moduleDO.getParameters();
            params = paramSet.toArray(new ModuleParameterDO[paramSet.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getParameters";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return params;
    }

    public ModuleParameterDO getParameter(ModuleDO module, String paramName) {
        String query = "from ModuleParameterDO as param where param.name='" + paramName + "' and param.module.moduleIdentifierDO.name='" + module.getModuleIdentifierDO().getName() + "' and param.module.moduleIdentifierDO.version='" + module.getModuleIdentifierDO().getVersion() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        Object serviceDO = null;
        ModuleParameterDO paramDO = null;
        try {
            paramDO = (ModuleParameterDO)session.createQuery(query).uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getParameter";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            session.evict(serviceDO);
            this.hbConfig.closeSession();
        }
        return paramDO;
    }

    public ModuleDO getModule(String moduleName, String version, Session session) {
        String query = version != null && version.trim().length() != 0 ? "from ModuleDO as module where module.moduleIdentifierDO.name='" + moduleName.trim() + "' and module.moduleIdentifierDO.version='" + version.trim() + "'" : "from ModuleDO as module where module.moduleIdentifierDO.name='" + moduleName.trim() + "' order by module.moduleIdentifierDO.version";
        List list = session.createQuery(query).list();
        if (!list.isEmpty()) {
            return (ModuleDO)list.get(0);
        }
        return null;
    }

    public ModuleDO[] getAllModules() {
        String query = "from ModuleDO";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ModuleDO[] modules = new ModuleDO[]{};
        try {
            List list = session.createQuery(query).list();
            modules = list.toArray(new ModuleDO[list.size()]);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getAllModules";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return modules;
    }
}

