/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.MaxTracedMessageSequenceDO;
import org.wso2.wsas.persistence.dataobject.MessageDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.util.HibernateConfig;

public class MessageDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)MessageDAO.class);

    public MessageDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public synchronized long getMaxMessageSequence(String serviceId, String serviceVersion, String operationName) {
        String query = "select sequenceId from MaxTracedMessageSequenceDO as msgSeq where msgSeq.serviceName='" + serviceId + "' and msgSeq.serviceVersion='" + serviceVersion + "' and msgSeq.operationName='" + operationName + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        long maxSeq = -1L;
        try {
            Object msg = session.createQuery(query).uniqueResult();
            System.out.println("####### MAX SEQ MSG=" + msg);
            Long seq = (Long)msg;
            if (seq != null) {
                maxSeq = seq;
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getMaxMessageSequence";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return maxSeq;
    }

    public synchronized void addMessage(MessageDO message) {
        String serviceId = message.getServiceId().trim();
        String serviceVersion = message.getServiceVersion().trim();
        String operationName = message.getOperationName().trim();
        String query = "select op from OperationDO as op inner join op.service as s where s.serviceIdentifierDO.serviceId='" + serviceId + "' and s.serviceIdentifierDO.version='" + serviceVersion + "' and op.name='" + operationName + "'";
        String query2 = "from MaxTracedMessageSequenceDO as msgSeq where msgSeq.serviceName='" + serviceId + "' and msgSeq.serviceVersion='" + serviceVersion + "' and msgSeq.operationName='" + operationName + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            OperationDO operationDO = (OperationDO)session.createQuery(query).uniqueResult();
            if (operationDO == null) {
                operationDO = new OperationDO();
                operationDO.setName(operationName);
                operationDO.setService(this.getService(serviceId, serviceVersion, session));
                session.save((Object)operationDO);
            }
            message.setOperationDO(operationDO);
            MaxTracedMessageSequenceDO maxMsgSeq = (MaxTracedMessageSequenceDO)session.createQuery(query2).uniqueResult();
            if (maxMsgSeq == null) {
                maxMsgSeq = new MaxTracedMessageSequenceDO(serviceId, serviceVersion, operationName, 1L);
                maxMsgSeq.setSequenceId(message.getSequence());
                session.save((Object)maxMsgSeq);
            } else {
                maxMsgSeq.setSequenceId(message.getSequence());
                session.update((Object)maxMsgSeq);
            }
            session.save((Object)message);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addMessage";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public MessageDO[] getMessages(MessageDO msgSearchCriteria) {
        String serviceId = msgSearchCriteria.getServiceId().trim();
        String serviceVersion = msgSearchCriteria.getServiceVersion().trim();
        String operationName = msgSearchCriteria.getOperationName().trim();
        int msgType = msgSearchCriteria.getType();
        long sequence = msgSearchCriteria.getSequence();
        String query = "select msg from MessageDO as msg inner join msg.operationDO as op inner join op.service as s where s.serviceIdentifierDO.serviceId='" + serviceId + "' and s.serviceIdentifierDO.version='" + serviceVersion + "' and op.name='" + operationName + "' " + (msgType != -1 && sequence != -1L ? " and " : "") + (msgType != -1 ? "msg.type=" + msgType : "") + (sequence != -1L ? " and msg.sequence=" + sequence : "") + " order by op.name";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Query hbQuery = session.createQuery(query);
            hbQuery.setMaxResults(100);
            List list = hbQuery.list();
            tx.commit();
            MessageDO[] messageDOArray = list.toArray(new MessageDO[list.size()]);
            return messageDOArray;
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getMessages";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    private ServiceDO getService(String serviceId, String version, Session session) {
        String query = "from ServiceDO as service where service.serviceIdentifierDO.serviceId='" + serviceId.trim() + "' and service.serviceIdentifierDO.version='" + version.trim() + "'";
        return (ServiceDO)session.createQuery(query).uniqueResult();
    }
}

