/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.util.HibernateConfig;

public class KeyStoreDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)KeyStoreDAO.class);

    public KeyStoreDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public KeyStoreDO[] getKeyStores() {
        String query = "from KeyStoreDO";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        KeyStoreDO[] keystores = new KeyStoreDO[]{};
        try {
            List list = session.createQuery(query).list();
            keystores = list.toArray(new KeyStoreDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to get transport keystores";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return keystores;
    }

    public KeyStoreDO getKeyStore(String ksName) {
        String userQuery = "from KeyStoreDO where keyStoreName='" + ksName.trim() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        KeyStoreDO keyStore = null;
        try {
            keyStore = (KeyStoreDO)session.createQuery(userQuery).uniqueResult();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getKeyStore";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return keyStore;
    }

    public void deleteKeyStore(String keyStoreName) {
        String userQuery = "from KeyStoreDO where keyStoreName='" + keyStoreName.trim() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            KeyStoreDO ksDO = (KeyStoreDO)session.createQuery(userQuery).uniqueResult();
            if (ksDO == null) {
                tx.rollback();
                return;
            }
            session.delete((Object)ksDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to delete keystore";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }
}

