/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.EJBProviderDO;
import org.wso2.wsas.util.HibernateConfig;

public class EJBConfigurationDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)EJBConfigurationDAO.class);

    public EJBConfigurationDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public void addEJBConfiguration(EJBProviderDO ejbProviderDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.save((Object)ejbProviderDO);
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to add EJB Configuration";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public EJBProviderDO[] getEJBConfigurations() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        EJBProviderDO[] ejbProviders = new EJBProviderDO[]{};
        try {
            Criteria ejbProviderCriteria = session.createCriteria(EJBProviderDO.class);
            List list = ejbProviderCriteria.list();
            ejbProviders = list.toArray(new EJBProviderDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve all ejb provider configurations";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return ejbProviders;
    }

    public void deleteEJBConfiguration(String beanJNDIName, String jnpProviderUrl) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria ejbCriteria = session.createCriteria(EJBProviderDO.class);
            ejbCriteria.add((Criterion)Expression.eq((String)"beanJNDIName", (Object)beanJNDIName));
            ejbCriteria.add((Criterion)Expression.eq((String)"providerURL", (Object)jnpProviderUrl));
            EJBProviderDO ejbProviderDO = (EJBProviderDO)ejbCriteria.uniqueResult();
            if (ejbProviderDO == null) {
                tx.rollback();
                return;
            }
            session.delete((Object)ejbProviderDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            tx.rollback();
            String msg = "Unable to delete EJB Configuration";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public EJBProviderDO getEJBConfiguration(String beanJNDIName, String jnpProviderUrl) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        EJBProviderDO ejbProviderDO = null;
        try {
            Criteria ejbCriteria = session.createCriteria(EJBProviderDO.class);
            ejbCriteria.add((Criterion)Expression.eq((String)"beanJNDIName", (Object)beanJNDIName));
            ejbCriteria.add((Criterion)Expression.eq((String)"providerURL", (Object)jnpProviderUrl));
            ejbProviderDO = (EJBProviderDO)ejbCriteria.uniqueResult();
            if (ejbProviderDO == null) {
                tx.rollback();
                EJBProviderDO eJBProviderDO = null;
                return eJBProviderDO;
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            if (e instanceof NonUniqueResultException) {
                String msg = "More than one EJB Configuration found";
                log.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            String msg = "Unable to retrieve EJB Configuration";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return ejbProviderDO;
    }
}

