/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.EJBAppServerDO;
import org.wso2.wsas.util.HibernateConfig;

public class EJBAppServerDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)EJBAppServerDAO.class);

    public EJBAppServerDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public void saveEJBAppServer(EJBAppServerDO ejbAppServerDO, boolean isUpdate) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            if (isUpdate) {
                session.update((Object)ejbAppServerDO);
            } else {
                session.save((Object)ejbAppServerDO);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to save EJB Application Server";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public EJBAppServerDO[] getEJBAppServers() {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        EJBAppServerDO[] ejbAppServers = new EJBAppServerDO[]{};
        try {
            Criteria ejbProviderCriteria = session.createCriteria(EJBAppServerDO.class);
            List list = ejbProviderCriteria.list();
            ejbAppServers = list.toArray(new EJBAppServerDO[list.size()]);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve all ejb application servers";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return ejbAppServers;
    }

    public void deleteEJBAppServer(String jnpProviderUrl) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria ejbCriteria = session.createCriteria(EJBAppServerDO.class);
            ejbCriteria.add((Criterion)Expression.eq((String)"providerURL", (Object)jnpProviderUrl));
            EJBAppServerDO ejbAppServerDO = (EJBAppServerDO)ejbCriteria.uniqueResult();
            if (ejbAppServerDO == null) {
                tx.rollback();
                return;
            }
            session.delete((Object)ejbAppServerDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            tx.rollback();
            String msg = "Unable to delete EJB Application Server";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public EJBAppServerDO getEJBAppServer(String jnpProviderUrl) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        EJBAppServerDO ejbAppServerDO = null;
        try {
            Criteria ejbCriteria = session.createCriteria(EJBAppServerDO.class);
            ejbCriteria.add((Criterion)Expression.eq((String)"providerURL", (Object)jnpProviderUrl));
            ejbAppServerDO = (EJBAppServerDO)ejbCriteria.uniqueResult();
            if (ejbAppServerDO == null) {
                tx.rollback();
                EJBAppServerDO eJBAppServerDO = null;
                return eJBAppServerDO;
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to retrieve EJB Configuration";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return ejbAppServerDO;
    }
}

