/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.exception.ConstraintViolationException;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.util.HibernateConfig;

public class BaseDAO {
    private static final Log log = LogFactory.getLog((Class)BaseDAO.class);
    protected HibernateConfig hbConfig;

    public BaseDAO(HibernateConfig hbConfig) {
        this.hbConfig = hbConfig;
    }

    public Long create(AbstractDataObject trasientInstance) throws DuplicateEntityException {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            trasientInstance.setLastUpdatedTime(new Date());
            session.persist((Object)trasientInstance);
            session.flush();
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            String msg = "Trying to create duplicate entity";
            log.warn((Object)msg, (Throwable)e);
            throw new DuplicateEntityException(msg, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            tx.rollback();
            throw new RuntimeException("Cannot create entity", e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return trasientInstance.getId();
    }

    public Long createOrUpdate(AbstractDataObject instance) throws DuplicateEntityException {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            instance.setLastUpdatedTime(new Date());
            session.saveOrUpdate((Object)instance);
            session.flush();
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            String msg = "Trying to create duplicate entity";
            log.warn((Object)msg, (Throwable)e);
            throw new DuplicateEntityException(msg, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            tx.rollback();
            throw new RuntimeException("Cannot create entity", e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return instance.getId();
    }

    public void update(AbstractDataObject abstractDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            abstractDO.setLastUpdatedTime(new Date());
            session.merge((Object)abstractDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to update";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void delete(AbstractDataObject abstractDO) {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.delete((Object)abstractDO);
            session.flush();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to delete";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }
}

