/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.util.HibernateConfig;

public class AppenderDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog((Class)AppenderDAO.class);

    public AppenderDAO(HibernateConfig hbConfig) {
        super(hbConfig);
    }

    public AppenderDO getAppenderDO(String appenderName) {
        AppenderDO appeanderDO;
        String query = "from AppenderDO where name='" + appenderName + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            appeanderDO = (AppenderDO)session.createQuery(query).uniqueResult();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getAppenderDO";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return appeanderDO;
    }

    public void updateAppenderDO(AppenderDO appenderDO) {
        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO = (AppenderDO)session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                existingAppenderDO.setPattern(appenderDO.getPattern());
                existingAppenderDO.setLogFileName(appenderDO.getLogFileName());
                existingAppenderDO.setLoggers(appenderDO.getLoggers());
                existingAppenderDO.setIsFileAppender(appenderDO.getIsFileAppender());
                existingAppenderDO.setIsSysLogAppender(appenderDO.getIsSysLogAppender());
                existingAppenderDO.setSysLogHost(appenderDO.getSysLogHost());
                existingAppenderDO.setThreshold(appenderDO.getThreshold());
                existingAppenderDO.setFacility(appenderDO.getFacility());
                session.update((Object)existingAppenderDO);
            } else {
                session.save((Object)appenderDO);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to updateAppenderDO";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void addLogger(AppenderDO appenderDO, LoggerDO loggerDO) {
        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO = (AppenderDO)session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                existingAppenderDO.getLoggers().add(loggerDO);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to addLogger";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public Set getLoggers(AppenderDO appenderDO) {
        HashSet loggers = new HashSet();
        String query = "from AppenderDO where name='" + appenderDO.getName() + "'";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            AppenderDO existingAppenderDO = (AppenderDO)session.createQuery(query).uniqueResult();
            if (existingAppenderDO != null) {
                Iterator iter = existingAppenderDO.getLoggers().iterator();
                while (iter.hasNext()) {
                    loggers.add(iter.next());
                }
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to getLoggers";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return loggers;
    }

    public List getAllAppenders() {
        List appenders = new ArrayList();
        String query = "from AppenderDO";
        Session session = this.hbConfig.currentSession();
        Transaction transaction = session.beginTransaction();
        try {
            appenders = session.createQuery(query).list();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            String msg = "Unable to getAllAppenders";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
        return appenders;
    }
}

