/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.wso2.utils.ServerConfigurator;
import org.wso2.wsas.persistence.dao.AppenderDAO;
import org.wso2.wsas.persistence.dao.BaseDAO;
import org.wso2.wsas.persistence.dao.EJBAppServerDAO;
import org.wso2.wsas.persistence.dao.EJBConfigurationDAO;
import org.wso2.wsas.persistence.dao.KeyStoreDAO;
import org.wso2.wsas.persistence.dao.LoggerDAO;
import org.wso2.wsas.persistence.dao.MessageDAO;
import org.wso2.wsas.persistence.dao.ModuleDAO;
import org.wso2.wsas.persistence.dao.OperationDAO;
import org.wso2.wsas.persistence.dao.SecurityScenarioDAO;
import org.wso2.wsas.persistence.dao.SecurityTokenDAO;
import org.wso2.wsas.persistence.dao.ServerConfigurationDAO;
import org.wso2.wsas.persistence.dao.ServiceDAO;
import org.wso2.wsas.persistence.dao.ServiceGroupDAO;
import org.wso2.wsas.persistence.dao.TransportDAO;
import org.wso2.wsas.persistence.dao.UserDAO;
import org.wso2.wsas.persistence.dao.UserRoleDAO;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.EJBAppServerDO;
import org.wso2.wsas.persistence.dataobject.EJBProviderDO;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.persistence.dataobject.MessageDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.ModuleIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ModuleParameterDO;
import org.wso2.wsas.persistence.dataobject.ModulePolicyDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.OperationParameterDO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.persistence.dataobject.SecurityTokenDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupParameterDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ServiceParameterDO;
import org.wso2.wsas.persistence.dataobject.ServicePolicyDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.persistence.exception.EJBAppServerAlreadyExistsException;
import org.wso2.wsas.persistence.exception.EJBAppServerNotFoundException;
import org.wso2.wsas.persistence.exception.EJBConfigurationAlreadyExistsException;
import org.wso2.wsas.persistence.exception.EJBConfigurationNotFoundException;
import org.wso2.wsas.persistence.exception.KeyStoreAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ModuleAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ModuleNotFoundException;
import org.wso2.wsas.persistence.exception.ModulePolicyNotFoundException;
import org.wso2.wsas.persistence.exception.SecurityScenarioAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServiceAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServiceGroupNotFoundException;
import org.wso2.wsas.persistence.exception.ServiceNotFoundException;
import org.wso2.wsas.persistence.exception.ServicePolicyAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServicePolicyNotFoundException;
import org.wso2.wsas.persistence.exception.ServiceUserAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServiceUserNotFoundException;
import org.wso2.wsas.persistence.exception.TokenAlreadyExistsException;
import org.wso2.wsas.persistence.exception.TransportAlreadyExistsException;
import org.wso2.wsas.persistence.exception.UserRoleAlreadyExistsException;
import org.wso2.wsas.security.WSS4JUtil;
import org.wso2.wsas.util.HibernateConfig;
import org.wso2.wsas.util.HibernateConfigFactory;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.WsasUtils;

public class PersistenceManager {
    private HibernateConfig hbConfig = HibernateConfigFactory.getDefaultConfig("wso2wsas.db.HibernateConfig");
    private static Log log = LogFactory.getLog((Class)PersistenceManager.class);

    public Long addModule(ModuleDO module) throws ModuleAlreadyExistsException {
        try {
            return new ModuleDAO(this.hbConfig).create(module);
        }
        catch (DuplicateEntityException e) {
            throw new ModuleAlreadyExistsException(e);
        }
    }

    public ModuleDO getModule(String moduleName, String version) {
        return new ModuleDAO(this.hbConfig).getModule(moduleName, version);
    }

    public ModuleDO[] getAllModules() {
        return new ModuleDAO(this.hbConfig).getAllModules();
    }

    public void updateModule(ModuleDO module) throws ModuleNotFoundException {
        new ModuleDAO(this.hbConfig).update(module);
    }

    public void updateSecurityToken(SecurityTokenDO tokenDO) {
        new SecurityTokenDAO(this.hbConfig).update(tokenDO);
    }

    public SecurityTokenDO getSecurityToken(String tokenId) {
        return new SecurityTokenDAO(this.hbConfig).getToken(tokenId);
    }

    public Long addUserRole(ServiceUserRoleDO serviceUserRole) throws UserRoleAlreadyExistsException {
        try {
            Long id = new UserRoleDAO(this.hbConfig).create(serviceUserRole);
            serviceUserRole.notifyObservers();
            return id;
        }
        catch (DuplicateEntityException e) {
            throw new UserRoleAlreadyExistsException(e);
        }
    }

    public Long addOrUpdateUserRole(ServiceUserRoleDO serviceUserRole) throws UserRoleAlreadyExistsException {
        try {
            Long id = new UserRoleDAO(this.hbConfig).createOrUpdate(serviceUserRole);
            serviceUserRole.notifyObservers();
            return id;
        }
        catch (DuplicateEntityException e) {
            throw new UserRoleAlreadyExistsException(e);
        }
    }

    public Long addSecurityScenario(SecurityScenarioDO scenario) throws SecurityScenarioAlreadyExistsException {
        try {
            return new SecurityScenarioDAO(this.hbConfig).create(scenario);
        }
        catch (DuplicateEntityException e) {
            throw new SecurityScenarioAlreadyExistsException(e);
        }
    }

    public SecurityScenarioDO[] getAllSecurityScenarios() {
        return new SecurityScenarioDAO(this.hbConfig).getAllScenarios();
    }

    public Long addUser(ServiceUserDO serviceUser) throws ServiceUserAlreadyExistsException {
        try {
            Long id = new UserDAO(this.hbConfig).create(serviceUser);
            serviceUser.notifyObservers();
            return id;
        }
        catch (DuplicateEntityException e) {
            throw new ServiceUserAlreadyExistsException(e);
        }
    }

    public synchronized void assignUserToService(String username, String serviceId, String serviceVersion) throws ServiceUserNotFoundException, ServiceNotFoundException {
        ServiceUserDO user = new UserDAO(this.hbConfig).getUser(username);
        new ServiceDAO(this.hbConfig).addUser(serviceId, serviceVersion, user);
    }

    public synchronized void assignRoleToService(String roleName, String serviceId, String serviceVersion) throws ServiceUserNotFoundException, ServiceNotFoundException {
        ServiceUserRoleDO role = new UserRoleDAO(this.hbConfig).getUserRole(roleName);
        new ServiceDAO(this.hbConfig).addRole(serviceId, serviceVersion, role);
    }

    public ServiceUserDO getUser(String username) {
        return new UserDAO(this.hbConfig).getUser(username);
    }

    public ServiceUserRoleDO getRole(String role) {
        return new UserRoleDAO(this.hbConfig).getUserRole(role);
    }

    public void removeRoleFromService(String roleName, String serviceId, String serviceVersion, AxisService axisService) throws ServiceUserNotFoundException, ServiceNotFoundException {
        ServiceUserRoleDO role = new UserRoleDAO(this.hbConfig).getUserRole(roleName);
        new ServiceDAO(this.hbConfig).removeServiceRole(serviceId, serviceVersion, role, axisService);
    }

    public void removeUserFromService(String userName, String serviceId, String serviceVersion, AxisService axisService) throws ServiceUserNotFoundException, ServiceNotFoundException {
        ServiceUserDO user = new UserDAO(this.hbConfig).getUser(userName);
        new ServiceDAO(this.hbConfig).removeServiceUser(serviceId, serviceVersion, user, axisService);
    }

    public void deleteUser(String userName) {
        new UserDAO(this.hbConfig).deleteUser(userName);
    }

    public void deleteRole(String roleName) {
        new UserRoleDAO(this.hbConfig).deleteRole(roleName);
    }

    public void deleteRoleFromUser(String userName, String roleName) {
        new UserDAO(this.hbConfig).deleteRoleFromUser(userName, roleName);
    }

    public ServiceUserDO[] getUsers() {
        return new UserDAO(this.hbConfig).getUsers();
    }

    public void removeUser(String username) throws ServiceUserNotFoundException {
        new UserDAO(this.hbConfig).deleteUser(username);
    }

    public void deleteEntity(AbstractDataObject dataObject) {
        new BaseDAO(this.hbConfig).delete(dataObject);
    }

    public ServiceUserRoleDO[] getUserRoles() {
        return new UserRoleDAO(this.hbConfig).getUserRoles();
    }

    public ServiceDO getService(String serviceId, String serviceVersion) {
        if (serviceVersion == null || serviceVersion.trim().length() == 0) {
            serviceVersion = "$EMPTY$";
        }
        return new ServiceDAO(this.hbConfig).getService(serviceId, serviceVersion);
    }

    public void addServiceGroup(ServiceGroupDO sgDO) {
        new ServiceGroupDAO(this.hbConfig).createServiceGroup(sgDO);
    }

    public ServiceGroupDO getServiceGroup(String serviceGroupId) {
        return new ServiceGroupDAO(this.hbConfig).getServiceGroup(serviceGroupId);
    }

    public ServiceDO[] getServices(ServiceGroupDO serviceGroup) {
        return new ServiceGroupDAO(this.hbConfig).getServices(serviceGroup);
    }

    public Long addService(ServiceDO service) throws ServiceAlreadyExistsException {
        try {
            return new ServiceDAO(this.hbConfig).create(service);
        }
        catch (DuplicateEntityException e) {
            throw new ServiceAlreadyExistsException(e);
        }
    }

    public void updateService(ServiceDO service) throws ServiceNotFoundException {
        new ServiceDAO(this.hbConfig).update(service);
    }

    public void updateOperation(OperationDO operation) throws ServiceNotFoundException {
        new OperationDAO(this.hbConfig).update(operation);
    }

    public void updateUser(ServiceUserDO user) throws ServiceUserNotFoundException {
        new UserDAO(this.hbConfig).update(user);
        user.notifyObservers();
    }

    public ServiceUserRoleDO getServiceUserRole(String role) {
        return new UserRoleDAO(this.hbConfig).getUserRole(role);
    }

    public Long addTransport(TransportDO protocol) throws TransportAlreadyExistsException {
        try {
            return new TransportDAO(this.hbConfig).create(protocol);
        }
        catch (DuplicateEntityException e) {
            throw new TransportAlreadyExistsException(e);
        }
    }

    public TransportDO getTransport(String protocol) {
        return new TransportDAO(this.hbConfig).getTransport(protocol);
    }

    public TransportDO[] getTransports() {
        return new TransportDAO(this.hbConfig).getTransports();
    }

    public Long addKeyStore(KeyStoreDO keyStore) throws KeyStoreAlreadyExistsException {
        try {
            return new KeyStoreDAO(this.hbConfig).create(keyStore);
        }
        catch (DuplicateEntityException e) {
            throw new KeyStoreAlreadyExistsException(e);
        }
    }

    public Long addToken(SecurityTokenDO tokenDO) throws TokenAlreadyExistsException {
        try {
            return new SecurityTokenDAO(this.hbConfig).create(tokenDO);
        }
        catch (DuplicateEntityException e) {
            throw new TokenAlreadyExistsException(e);
        }
    }

    public void deleteKeyStore(String keyStoreName) {
        new KeyStoreDAO(this.hbConfig).deleteKeyStore(keyStoreName);
    }

    public KeyStoreDO[] getKeyStores() {
        return new KeyStoreDAO(this.hbConfig).getKeyStores();
    }

    public KeyStoreDO getKeyStore(String ksName) {
        return new KeyStoreDAO(this.hbConfig).getKeyStore(ksName);
    }

    public String getConfigurationProperty(String propertyName) {
        return new ServerConfigurationDAO(this.hbConfig).getConfigurationProperty(propertyName);
    }

    public void updateConfigurationProperty(String propertyName, String value) {
        new ServerConfigurationDAO(this.hbConfig).updateConfigurationProperty(propertyName, value);
    }

    public void addServicePolicy(ServicePolicyDO servicePolicy) throws ServicePolicyAlreadyExistsException {
        String serviceId = servicePolicy.getService().getServiceIdentifierDO().getServiceId();
        String serviceVersion = servicePolicy.getService().getServiceIdentifierDO().getVersion();
        new ServiceDAO(this.hbConfig).addPolicy(serviceId, serviceVersion, servicePolicy);
    }

    public void updateServicePolicy(ServicePolicyDO servicePolicy) throws ServicePolicyNotFoundException {
        new ServiceDAO(this.hbConfig).updatePolicy(servicePolicy);
    }

    public void updateModulePolicy(ModulePolicyDO modulePolicy) throws ModulePolicyNotFoundException {
        new ModuleDAO(this.hbConfig).updatePolicy(modulePolicy);
    }

    public synchronized long getMaxMessageSequence(String serviceId, String serviceVersion, String operationName) {
        return new MessageDAO(this.hbConfig).getMaxMessageSequence(serviceId, serviceVersion, operationName);
    }

    public void addMessage(MessageDO message) {
        new MessageDAO(this.hbConfig).addMessage(message);
    }

    public MessageDO[] getMessages(MessageDO msgSearchCriteria) {
        return new MessageDAO(this.hbConfig).getMessages(msgSearchCriteria);
    }

    public void deleteService(String serviceId, String serviceVersion) throws ServiceNotFoundException {
        new ServiceDAO(this.hbConfig).deleteService(serviceId, serviceVersion);
    }

    public void deleteServiceGroup(AxisServiceGroup serviceGroup) throws ServiceGroupNotFoundException {
        Iterator services = serviceGroup.getServices();
        if (services.hasNext() && ((AxisService)services.next()).isClientSide()) {
            return;
        }
        new ServiceGroupDAO(this.hbConfig).deleteServiceGroup(serviceGroup.getServiceGroupName());
    }

    public ServiceUserDO[] getUsersForService(String serviceId, String serviceVersion) {
        return new ServiceDAO(this.hbConfig).getUsers(serviceId, serviceVersion);
    }

    public ServiceUserRoleDO[] getRolesForService(String serviceId, String serviceVersion) {
        return new ServiceDAO(this.hbConfig).getRoles(serviceId, serviceVersion);
    }

    public void addEngagedOperationToModule(String moduleName, String moduleVersion, OperationDO op) {
        new ModuleDAO(this.hbConfig).addEngagedOperation(moduleName, moduleVersion, op);
    }

    public void addEngagedServiceToModule(String moduleName, String moduleVersion, ServiceDO service) {
        if (service == null) {
            return;
        }
        new ModuleDAO(this.hbConfig).addEngagedService(moduleName, moduleVersion, service);
    }

    public void addEngagedServiceGroupToModule(String moduleName, String moduleVersion, ServiceGroupDO serviceGrp) {
        if (serviceGrp == null) {
            return;
        }
        new ModuleDAO(this.hbConfig).addEngagedServiceGroup(moduleName, moduleVersion, serviceGrp);
    }

    public void addPolicyToService(String serviceId, String serviceVersion, ServicePolicyDO policy) {
        new ServiceDAO(this.hbConfig).addPolicy(serviceId, serviceVersion, policy);
    }

    public void addParameterToService(String serviceId, String serviceVersion, ServiceParameterDO param) {
        new ServiceDAO(this.hbConfig).addParameter(serviceId, serviceVersion, param);
    }

    public void addPolicyToModule(String moduleName, String moduleVersion, ModulePolicyDO policy) {
        new ModuleDAO(this.hbConfig).addPolicy(moduleName, moduleVersion, policy);
    }

    public void addParameterToModule(String moduleName, String moduleVersion, ModuleParameterDO param) {
        new ModuleDAO(this.hbConfig).addParameter(moduleName, moduleVersion, param);
    }

    public OperationDO[] getServiceOperations(String serviceId, String serviceVersion) {
        return new ServiceDAO(this.hbConfig).getOperations(serviceId, serviceVersion);
    }

    public OperationDO[] getServiceOperations(ServiceDO service) {
        return new ServiceDAO(this.hbConfig).getOperations(service);
    }

    public OperationDO[] getEngagedOperations(String moduleName, String moduleVersion) {
        return new ModuleDAO(this.hbConfig).getEngagedOperations(moduleName, moduleVersion);
    }

    public ServiceDO[] getEngagedServices(String moduleName, String moduleVersion) {
        return new ModuleDAO(this.hbConfig).getEngagedServices(moduleName, moduleVersion);
    }

    public ModuleDO[] getEngagedModules(String serviceId, String serviceVersion) {
        return new ServiceDAO(this.hbConfig).getEngagedModules(serviceId, serviceVersion);
    }

    public ModuleDO[] getEngagedModules(ServiceDO service) {
        return new ServiceDAO(this.hbConfig).getEngagedModules(service);
    }

    public ModuleDO[] getEngagedModules(OperationDO op) {
        return new OperationDAO(this.hbConfig).getEngagedModules(op);
    }

    public ServiceParameterDO[] getServiceParameters(ServiceDO service) {
        return new ServiceDAO(this.hbConfig).getParameters(service);
    }

    public ServiceParameterDO getServiceParameter(ServiceDO service, String paramName) {
        return new ServiceDAO(this.hbConfig).getParameter(service, paramName);
    }

    public ServiceGroupParameterDO getServiceGroupParameter(ServiceGroupDO serviceGroup, String paramName) {
        return new ServiceGroupDAO(this.hbConfig).getParameter(serviceGroup, paramName);
    }

    public OperationParameterDO getOperationParameter(String serviceId, String serviceVersion, String operationId, String paramName) {
        return new OperationDAO(this.hbConfig).getOperationParameter(serviceId, serviceVersion, operationId, paramName);
    }

    public ServicePolicyDO[] getServicePolicies(ServiceDO service) {
        return new ServiceDAO(this.hbConfig).getPolicies(service);
    }

    public ModulePolicyDO[] getModulePolicies(ModuleDO module) {
        return new ModuleDAO(this.hbConfig).getPolicies(module);
    }

    public ModulePolicyDO[] getModulePolicies(String moduleName, String moduleVersion) {
        return new ModuleDAO(this.hbConfig).getPolicies(moduleName, moduleVersion);
    }

    public OperationParameterDO[] getOperationParameters(OperationDO op) {
        return new OperationDAO(this.hbConfig).getParameters(op);
    }

    public ModuleParameterDO[] getModuleParameters(ModuleDO module) {
        return new ModuleDAO(this.hbConfig).getParameters(module);
    }

    public ModuleParameterDO getModuleParameter(ModuleDO module, String paramName) {
        return new ModuleDAO(this.hbConfig).getParameter(module, paramName);
    }

    public ServiceUserRoleDO getUserRole(String role) {
        return new UserRoleDAO(this.hbConfig).getUserRole(role);
    }

    public ServiceUserRoleDO[] getUserRoles(ServiceUserDO user) {
        return new UserDAO(this.hbConfig).getUserRoles(user);
    }

    public ServiceUserRoleDO[] getUserSpecificRoles(String user) {
        return new UserDAO(this.hbConfig).getRoles(user);
    }

    public void addRole(String userName, ServiceUserRoleDO role) {
        new UserDAO(this.hbConfig).addRole(userName, role);
        role.notifyObservers();
    }

    public OperationDO getOperation(String serviceId, String serviceVersion, String opName) {
        return new OperationDAO(this.hbConfig).getOperation(serviceId, serviceVersion, opName);
    }

    public OperationDO[] getOperations(ServiceDO service) {
        return new ServiceDAO(this.hbConfig).getOperations(service);
    }

    public void addEntity(AbstractDataObject obj) throws DuplicateEntityException {
        new BaseDAO(this.hbConfig).create(obj);
    }

    public void updateEntity(AbstractDataObject obj) {
        new BaseDAO(this.hbConfig).update(obj);
    }

    public void removeEngagedServiceFromModule(String moduleName, String moduleVersion, ServiceDO service) {
        if (service != null) {
            new ModuleDAO(this.hbConfig).removeEngagedService(moduleName, moduleVersion, service);
        }
    }

    public void removeEngagedServiceGroupFromModule(String moduleName, String moduleVersion, ServiceGroupDO serviceGrp) {
        if (serviceGrp != null) {
            new ModuleDAO(this.hbConfig).removeEngagedServiceGroup(moduleName, moduleVersion, serviceGrp);
        }
    }

    public void removeEngagedOperationFromModule(String moduleName, String moduleVersion, OperationDO operation) {
        if (operation != null) {
            new ModuleDAO(this.hbConfig).removeEngagedOperation(moduleName, moduleVersion, operation);
        }
    }

    public void deleteModule(String moduleName, String moduleVersion) {
        new ModuleDAO(this.hbConfig).deleteModule(moduleName, moduleVersion);
    }

    public void handleNewServiceAddition(AxisService axisService) throws Exception {
        if (axisService.isClientSide()) {
            return;
        }
        String sgName = ((AxisServiceGroup)axisService.getParent()).getServiceGroupName();
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        ServiceGroupDO serviceGroupDO = new ServiceGroupDAO(this.hbConfig).getServiceGroup(sgName, session);
        if (serviceGroupDO == null) {
            tx.rollback();
            return;
        }
        ServiceDO serviceDO = new ServiceDO();
        ServiceIdentifierDO serviceIdentifier = new ServiceIdentifierDO();
        serviceDO.setServiceIdentifierDO(serviceIdentifier);
        serviceIdentifier.setServiceId(axisService.getName());
        serviceIdentifier.setVersion("$EMPTY$");
        serviceDO.setDocumentation(axisService.getDocumentation());
        ServicePolicyDO[] servicePolicies = this.getServicePolicies(axisService);
        for (int i = 0; i < servicePolicies.length; ++i) {
            serviceDO.addPolicy(servicePolicies[i]);
        }
        Iterator iter = axisService.getOperations();
        while (iter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iter.next();
            OperationDO op = new OperationDO();
            op.setName(axisOperation.getName().getLocalPart());
            op.setDocumentation(axisOperation.getDocumentation());
            serviceDO.addOperation(op);
        }
        if (axisService.getScope().equals("soapsession") && !axisService.isEngaged("addressing")) {
            axisService.engageModule(axisService.getAxisConfiguration().getModule("addressing"));
        }
        serviceDO.setServiceGroup(serviceGroupDO);
        try {
            serviceDO.setLastUpdatedTime(new Date());
            serviceDO.setIsActive(true);
            session.persist((Object)serviceDO);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new service - " + axisService.getName()));
            }
            ModuleDAO modDAO = new ModuleDAO(this.hbConfig);
            Iterator serviceModuleEngagementIter = axisService.getEngagedModules().iterator();
            while (serviceModuleEngagementIter.hasNext()) {
                ModuleDO moduleDO;
                AxisModule axisModule = (AxisModule)serviceModuleEngagementIter.next();
                String moduleName = axisModule.getName();
                String moduleVersion = axisModule.getVersion();
                if (moduleVersion == null) {
                    moduleVersion = "";
                }
                if (axisService.getParent().isEngaged(axisModule.getName()) || (moduleDO = modDAO.getModule(moduleName, moduleVersion, session)) == null || moduleDO.getEngagedServices().contains(serviceDO)) continue;
                moduleDO.addService(serviceDO);
                session.update((Object)moduleDO);
                session.update((Object)serviceDO);
            }
            OperationDAO opDAO = new OperationDAO(this.hbConfig);
            Iterator iter2 = axisService.getOperations();
            while (iter2.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iter2.next();
                Iterator opModuleEngagementIter = axisOperation.getEngagedModules().iterator();
                while (opModuleEngagementIter.hasNext()) {
                    ModuleDO moduleDO;
                    AxisModule axisModule = (AxisModule)opModuleEngagementIter.next();
                    if (axisService.isEngaged(axisModule.getName())) continue;
                    OperationDO opDO = opDAO.getOperation(axisService.getName(), "$EMPTY$", axisOperation.getName().getLocalPart(), session);
                    String moduleName = axisModule.getName();
                    String moduleVersion = axisModule.getVersion();
                    if (moduleVersion == null) {
                        moduleVersion = "";
                    }
                    if ((moduleDO = modDAO.getModule(moduleName, moduleVersion, session)) == null || moduleDO.getEngagedOperations().contains(serviceDO)) continue;
                    moduleDO.addOperation(opDO);
                    session.update((Object)moduleDO);
                    session.update((Object)opDO);
                }
            }
            iter2 = axisService.getParameters().iterator();
            while (iter2.hasNext()) {
                Parameter parameter = (Parameter)iter2.next();
                String paramName = parameter.getName();
                if (paramName == null || paramName.trim().length() == 0) continue;
                ServiceParameterDO parameterDO = new ServiceParameterDO();
                parameterDO.setName(paramName);
                if (parameter.getParameterElement() != null) {
                    parameterDO.setValue(parameter.getParameterElement().toString());
                    parameterDO.setService(serviceDO);
                    continue;
                }
                if (parameter.getValue() == null || !(parameter.getValue() instanceof String)) continue;
                parameter = ParameterUtil.createParameter(paramName.trim(), (String)parameter.getValue());
                parameterDO.setValue(parameter.getParameterElement().toString());
                parameterDO.setService(serviceDO);
            }
            serviceDO.setIsExposedOnAllTransports(axisService.isEnableAllTransports());
            if (!axisService.isEnableAllTransports()) {
                List exposedTransports = axisService.getExposedTransports();
                TransportDAO transportDAO = new TransportDAO(this.hbConfig);
                Iterator iterator = exposedTransports.iterator();
                while (iterator.hasNext()) {
                    TransportDO transportDO = transportDAO.getTransport((String)iterator.next(), session);
                    serviceDO.addTransport(transportDO);
                }
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle new service addition", (Throwable)e);
            session.flush();
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    private ServicePolicyDO[] getServicePolicies(AxisService service) throws XMLStreamException {
        PolicyInclude include = service.getPolicyInclude();
        ArrayList servicePolicyDOs = new ArrayList();
        this.addServicePolicy(include, servicePolicyDOs, 3);
        this.addServicePolicy(include, servicePolicyDOs, 6);
        this.addServicePolicy(include, servicePolicyDOs, 7);
        this.addServicePolicy(include, servicePolicyDOs, 9);
        this.addServicePolicy(include, servicePolicyDOs, 8);
        return servicePolicyDOs.toArray(new ServicePolicyDO[servicePolicyDOs.size()]);
    }

    private ModulePolicyDO[] getModulePolicies(AxisModule axisModule) throws XMLStreamException {
        PolicyInclude include = axisModule.getPolicyInclude();
        ArrayList modulePolicyDOs = new ArrayList();
        this.addModulePolicy(include, modulePolicyDOs, 2);
        return modulePolicyDOs.toArray(new ModulePolicyDO[modulePolicyDOs.size()]);
    }

    private void addServicePolicy(PolicyInclude include, List servicePolicyDOs, int policyType) throws XMLStreamException {
        Iterator iterator = include.getPolicyElements(policyType).iterator();
        while (iterator.hasNext()) {
            Policy policy;
            ServicePolicyDO servicePolicyDO = new ServicePolicyDO();
            servicePolicyDO.setType(policyType);
            Object o = iterator.next();
            if (o instanceof Policy) {
                policy = (Policy)o;
            } else if (o instanceof PolicyReference) {
                PolicyReference pRef = (PolicyReference)o;
                PolicyRegistry policyRegistry = include.getPolicyRegistry();
                String key = pRef.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                policy = policyRegistry.lookup(key);
            } else {
                throw new IllegalArgumentException("Invalid Policy Item found in collection. This is a programmatic error");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
            policy.serialize(writer);
            writer.flush();
            servicePolicyDO.setUuid(policy.getId());
            servicePolicyDO.setPolicy(baos.toString());
            servicePolicyDOs.add(servicePolicyDO);
        }
    }

    private void addModulePolicy(PolicyInclude include, List modulePolicyDOs, int policyType) throws XMLStreamException {
        Iterator iterator = include.getPolicyElements(policyType).iterator();
        while (iterator.hasNext()) {
            Policy policy;
            ModulePolicyDO modulePolicyDO = new ModulePolicyDO();
            modulePolicyDO.setType(policyType);
            Object o = iterator.next();
            if (o instanceof Policy) {
                policy = (Policy)o;
            } else if (o instanceof PolicyReference) {
                PolicyReference pRef = (PolicyReference)o;
                PolicyRegistry policyRegistry = include.getPolicyRegistry();
                String key = pRef.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                policy = policyRegistry.lookup(key);
            } else {
                throw new IllegalArgumentException("Invalid Policy Item found in collection. This is a programmatic error");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
            policy.serialize(writer);
            writer.flush();
            modulePolicyDO.setUuid(policy.getId());
            modulePolicyDO.setPolicy(baos.toString());
            modulePolicyDOs.add(modulePolicyDO);
        }
    }

    public void handleExistingServiceInit(ServiceDO serviceDO, AxisService axisService, AxisConfiguration axisConfig) throws Exception {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            serviceDO = (ServiceDO)session.load(ServiceDO.class, (Serializable)serviceDO.getId());
            String serviceId = serviceDO.getServiceIdentifierDO().getServiceId();
            String version = serviceDO.getServiceIdentifierDO().getVersion();
            axisService.addParameter(WSS4JUtil.getPasswordCallBackRefParameter(serviceId, version));
            PolicyInclude policyInclude = axisService.getPolicyInclude();
            policyInclude.removeAllPolicyElements();
            Iterator iter = serviceDO.getPolicies().iterator();
            while (iter.hasNext()) {
                ServicePolicyDO policyDO = (ServicePolicyDO)iter.next();
                String policyStr = policyDO.getPolicy();
                Policy policy = PolicyEngine.getPolicy((InputStream)new ByteArrayInputStream(policyStr.getBytes()));
                policyInclude.addPolicyElement(policyDO.getType(), policy);
            }
            iter = serviceDO.getParameters().iterator();
            while (iter.hasNext()) {
                StAXOMBuilder builder;
                ServiceParameterDO paramDO = (ServiceParameterDO)iter.next();
                paramDO.getValue();
                ByteArrayInputStream bais = new ByteArrayInputStream(paramDO.getValue().getBytes());
                try {
                    builder = new StAXOMBuilder((InputStream)bais);
                }
                catch (XMLStreamException e) {
                    String msg = "Unable to set service parameter";
                    log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
                Parameter parameter = ParameterUtil.createParameter(builder.getDocumentElement());
                Parameter p = axisService.getParameter(paramDO.getName());
                if (p != null) {
                    if (p.isLocked()) continue;
                    axisService.addParameter(parameter);
                    continue;
                }
                axisService.addParameter(parameter);
            }
            String doc = serviceDO.getDocumentation();
            if (doc != null) {
                axisService.setDocumentation(doc);
            }
            axisService.getEngagedModules().clear();
            Iterator iter2 = serviceDO.getEngagedModules().iterator();
            while (iter2.hasNext()) {
                ModuleDO moduleDO = (ModuleDO)iter2.next();
                ModuleIdentifierDO modID = moduleDO.getModuleIdentifierDO();
                AxisModule axisModule = axisConfig.getModule(modID.getName(), modID.getVersion());
                if (this.isGloballyEngaged(modID.getName(), modID.getVersion(), session)) continue;
                axisService.disengageModule(axisModule);
                axisService.engageModule(axisModule);
            }
            iter2 = serviceDO.getOperations().iterator();
            while (iter2.hasNext()) {
                OperationDO opDO = (OperationDO)iter2.next();
                AxisOperation axisOp = axisService.getOperation(new QName(opDO.getName()));
                axisOp.getEngagedModules().clear();
                Iterator iter22 = opDO.getEngagedModules().iterator();
                while (iter22.hasNext()) {
                    ModuleDO moduleDO = (ModuleDO)iter22.next();
                    ModuleIdentifierDO modID = moduleDO.getModuleIdentifierDO();
                    AxisModule axisModule = axisConfig.getModule(modID.getName(), modID.getVersion());
                    if (this.isGloballyEngaged(modID.getName(), modID.getVersion(), session) || axisService.isEngaged(axisModule) || axisOp.isControlOperation() || axisOp.isEngaged(axisModule)) continue;
                    axisOp.engageModule(axisModule);
                }
                String documentation = opDO.getDocumentation();
                if (documentation != null) {
                    axisOp.setDocumentation(documentation);
                }
                Iterator opIter = opDO.getParameters().iterator();
                while (opIter.hasNext()) {
                    StAXOMBuilder builder;
                    OperationParameterDO opParamDO = (OperationParameterDO)opIter.next();
                    opParamDO.getValue();
                    ByteArrayInputStream bais = new ByteArrayInputStream(opParamDO.getValue().getBytes());
                    try {
                        builder = new StAXOMBuilder((InputStream)bais);
                    }
                    catch (XMLStreamException e) {
                        String msg = "Unable to set operation parameter";
                        log.error((Object)msg, (Throwable)e);
                        throw new AxisFault(msg, (Throwable)e);
                    }
                    Parameter parameter = ParameterUtil.createParameter(builder.getDocumentElement());
                    Parameter p = axisOp.getParameter(opParamDO.getName());
                    if (p != null) {
                        if (p.isLocked()) continue;
                        axisOp.addParameter(parameter);
                        continue;
                    }
                    axisOp.addParameter(parameter);
                }
            }
            if (!serviceDO.getIsExposedOnAllTransports()) {
                axisService.setExposedTransports(new ArrayList());
                Iterator transpIter = serviceDO.getTransports().iterator();
                while (transpIter.hasNext()) {
                    String transportProtocol = ((TransportDO)transpIter.next()).getTransportProtocol();
                    axisService.addExposedTransport(transportProtocol);
                }
            }
            axisService.setActive(serviceDO.getIsActive());
            tx.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized service - " + serviceDO.getServiceIdentifierDO().getServiceId()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle service initialization", (Throwable)e);
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    private boolean isGloballyEngaged(String moduleId, String moduleVersion, Session session) {
        String query = "from ModuleDO";
        List list = session.createQuery(query).list();
        ModuleDO[] modules = list.toArray(new ModuleDO[list.size()]);
        for (int i = 0; i < modules.length; ++i) {
            ModuleDO moduleDO = modules[i];
            if (!moduleDO.getIsGloballyEngaged() || !moduleDO.getModuleIdentifierDO().getName().equals(moduleId) || !moduleDO.getModuleIdentifierDO().getVersion().equals(moduleVersion)) continue;
            return true;
        }
        return false;
    }

    public void handleExistingServiceGroupInit(ServiceGroupDO sgDO, AxisServiceGroup serviceGroup) throws Exception {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            sgDO = (ServiceGroupDO)session.load(ServiceGroupDO.class, (Serializable)sgDO.getId());
            Iterator iter = sgDO.getParameters().iterator();
            while (iter.hasNext()) {
                StAXOMBuilder builder;
                ServiceGroupParameterDO paramDO = (ServiceGroupParameterDO)iter.next();
                paramDO.getValue();
                ByteArrayInputStream bais = new ByteArrayInputStream(paramDO.getValue().getBytes());
                try {
                    builder = new StAXOMBuilder((InputStream)bais);
                }
                catch (XMLStreamException e) {
                    String msg = "Unable to set service group parameter";
                    log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
                Parameter parameter = ParameterUtil.createParameter(builder.getDocumentElement());
                Parameter p = serviceGroup.getParameter(paramDO.getName());
                if (p != null) {
                    if (p.isLocked()) continue;
                    serviceGroup.addParameter(parameter);
                    continue;
                }
                serviceGroup.addParameter(parameter);
            }
            AxisConfiguration axisConfig = serviceGroup.getAxisConfiguration();
            serviceGroup.getEngagedModules().clear();
            Iterator iter2 = sgDO.getEngagedModules().iterator();
            while (iter2.hasNext()) {
                ModuleDO moduleDO = (ModuleDO)iter2.next();
                ModuleIdentifierDO modID = moduleDO.getModuleIdentifierDO();
                AxisModule axisModule = axisConfig.getModule(modID.getName(), modID.getVersion());
                if (this.isGloballyEngaged(modID.getName(), modID.getVersion(), session)) continue;
                serviceGroup.disengageModule(axisModule);
                serviceGroup.engageModule(axisModule);
            }
            tx.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized Service Group - " + sgDO.getName()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle service group init", (Throwable)e);
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public void handleNewServiceGroupAddition(AxisServiceGroup serviceGroup) throws Exception {
        Iterator services = serviceGroup.getServices();
        if (services.hasNext() && ((AxisService)services.next()).isClientSide()) {
            return;
        }
        ServiceGroupDO sgDO = new ServiceGroupDO();
        sgDO.setServiceArtifactUpdateTime(WsasUtils.lastUpdatedTime(serviceGroup));
        String sgName = serviceGroup.getServiceGroupName();
        sgDO.setName(sgName);
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        AxisConfiguration axisConfiguration = serviceGroup.getAxisConfiguration();
        try {
            ModuleDAO moduleDAO = new ModuleDAO(this.hbConfig);
            Iterator iter = serviceGroup.getEngagedModules().iterator();
            while (iter.hasNext()) {
                ModuleDO moduleDO;
                AxisModule axisModule = (AxisModule)iter.next();
                if (axisConfiguration.isEngaged(axisModule.getName()) || (moduleDO = moduleDAO.getModule(axisModule.getName(), axisModule.getVersion(), session)) == null || !moduleDO.getEngagedServiceGroups().contains(sgDO)) continue;
                sgDO.addModule(moduleDO);
            }
            iter = serviceGroup.getParameters().iterator();
            while (iter.hasNext()) {
                Parameter parameter = (Parameter)iter.next();
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) continue;
                ServiceGroupParameterDO paramDO = new ServiceGroupParameterDO();
                paramDO.setName(parameter.getName());
                if (parameter.getParameterElement() == null) continue;
                paramDO.setValue(parameter.getParameterElement().toString());
                paramDO.setServiceGroup(sgDO);
            }
            new ServiceGroupDAO(this.hbConfig).createServiceGroup(sgDO, session);
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle new service group addition", (Throwable)e);
            session.flush();
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added new service group - " + sgName));
        }
    }

    public void handleNewModuleAddition(AxisModule axisModule, String moduleName, String moduleVersion) throws Exception {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            ModuleDO moduleDO = new ModuleDO();
            ModuleIdentifierDO modID = new ModuleIdentifierDO();
            modID.setName(moduleName);
            modID.setVersion(moduleVersion);
            moduleDO.setModuleIdentifierDO(modID);
            moduleDO.setIsGloballyEngaged(ServerConfigurator.getInstance().isGlobalyEngaged(axisModule));
            Iterator iter = axisModule.getParameters().iterator();
            while (iter.hasNext()) {
                Parameter param = (Parameter)iter.next();
                ModuleParameterDO paramDO = new ModuleParameterDO();
                paramDO.setName(param.getName());
                paramDO.setValue(param.getParameterElement().toString());
                moduleDO.addParameter(paramDO);
            }
            session.persist((Object)moduleDO);
            ModulePolicyDO[] modulePolicies = this.getModulePolicies(axisModule);
            for (int i = 0; i < modulePolicies.length; ++i) {
                moduleDO.addPolicy(modulePolicies[i]);
            }
            session.flush();
            tx.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new module - " + axisModule.getName() + "-" + axisModule.getVersion()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle new module addition", (Throwable)e);
            this.markFaultyModule(axisModule);
            session.flush();
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    private void markFaultyModule(AxisModule axisModule) {
        axisModule.getParent().getFaultyModules().put(Utils.getModuleName((String)axisModule.getName(), (String)axisModule.getVersion()), axisModule);
    }

    public void handleExistingModuleInit(ModuleDO moduleDO, AxisModule axisModule) throws Exception {
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            moduleDO = (ModuleDO)session.load(ModuleDO.class, (Serializable)moduleDO.getId());
            Iterator iter = moduleDO.getParameters().iterator();
            while (iter.hasNext()) {
                StAXOMBuilder builder;
                ModuleParameterDO param = (ModuleParameterDO)iter.next();
                ByteArrayInputStream bais = new ByteArrayInputStream(param.getValue().getBytes());
                try {
                    builder = new StAXOMBuilder((InputStream)bais);
                }
                catch (XMLStreamException e) {
                    String msg = "Unable to set service parameter";
                    log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
                Parameter parameter = ParameterUtil.createParameter(builder.getDocumentElement());
                Parameter p = axisModule.getParameter(param.getName());
                if (p != null) {
                    if (p.isLocked()) continue;
                    axisModule.addParameter(parameter);
                    continue;
                }
                axisModule.addParameter(parameter);
            }
            PolicyInclude policyInclude = axisModule.getPolicyInclude();
            policyInclude.removeAllPolicyElements();
            Iterator iter2 = moduleDO.getPolicies().iterator();
            while (iter2.hasNext()) {
                ModulePolicyDO policyDO = (ModulePolicyDO)iter2.next();
                String policyStr = policyDO.getPolicy();
                Policy policy = PolicyEngine.getPolicy((InputStream)new ByteArrayInputStream(policyStr.getBytes()));
                policyInclude.addPolicyElement(policyDO.getType(), policy);
            }
            tx.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized module - " + Utils.getModuleName((String)axisModule.getName(), (String)axisModule.getVersion())));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to handle module init", (Throwable)e);
            this.markFaultyModule(axisModule);
            tx.rollback();
            throw e;
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public boolean userHasRole(String username, ServiceUserRoleDO role) {
        return new UserDAO(this.hbConfig).userHasRole(username, role);
    }

    public List getAllAppenders() {
        return new AppenderDAO(this.hbConfig).getAllAppenders();
    }

    public List getAllLoggers() {
        return new LoggerDAO(this.hbConfig).getAllLoggers();
    }

    public void addAppender(AppenderDO appenderDO) {
        new AppenderDAO(this.hbConfig).updateAppenderDO(appenderDO);
    }

    public void addLogger(LoggerDO loggerDO) {
        new LoggerDAO(this.hbConfig).updateLoggerDO(loggerDO);
    }

    public AppenderDO getAppenderDO(String appenderName) {
        return new AppenderDAO(this.hbConfig).getAppenderDO(appenderName);
    }

    public LoggerDO getLoggerDO(String loggerName) {
        return new LoggerDAO(this.hbConfig).getLoggerDO(loggerName);
    }

    public void updateAppenderData(String appenderName, String appenderPattern, String threshold, String logFileName, String sysLogHost, String facility, boolean isFileAppender, boolean isSysLogAppender) {
        AppenderDO appenderDO = new AppenderDO();
        appenderDO.setName(appenderName);
        appenderDO.setPattern(appenderPattern);
        appenderDO.setThreshold(threshold);
        appenderDO.setLogFileName(logFileName);
        appenderDO.setSysLogHost(sysLogHost);
        appenderDO.setFacility(facility);
        appenderDO.setIsFileAppender(isFileAppender);
        appenderDO.setIsSysLogAppender(isSysLogAppender);
        new AppenderDAO(this.hbConfig).updateAppenderDO(appenderDO);
    }

    public void updateLoggerData(String loggerName, String loggerLevel, boolean aditivity) {
        LoggerDO loggerDO = new LoggerDO();
        loggerDO.setName(loggerName);
        loggerDO.setLogLevel(loggerLevel);
        loggerDO.setAdditivity(aditivity);
        new LoggerDAO(this.hbConfig).updateLoggerDO(loggerDO);
    }

    public SecurityTokenDO[] getAllSecurityTokens() {
        return new SecurityTokenDAO(this.hbConfig).getAllTokens();
    }

    public SecurityScenarioDO getSecurityScenario(String scenarioId) {
        return new SecurityScenarioDAO(this.hbConfig).getSecurityScenario(scenarioId);
    }

    public void removeAllTrustedCertStores(ServiceDO serviceDO) {
        new ServiceDAO(this.hbConfig).removeAllTrustedCertStores(serviceDO);
    }

    public void removeAllLoggersAndAppenders() {
        String loggerQuery = "delete from LoggerDO";
        String appenderQuery = "delete from AppenderDO";
        Session session = this.hbConfig.currentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.createQuery(loggerQuery).executeUpdate();
            session.createQuery(appenderQuery).executeUpdate();
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            String msg = "Unable to removeAllLoggersAndAppenders";
            log.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.hbConfig.closeSession();
        }
    }

    public Long addEJBConfiguration(EJBProviderDO ejbProvider) throws EJBConfigurationAlreadyExistsException {
        try {
            return new EJBConfigurationDAO(this.hbConfig).create(ejbProvider);
        }
        catch (DuplicateEntityException e) {
            throw new EJBConfigurationAlreadyExistsException(e);
        }
    }

    public EJBProviderDO[] getEJBConfigurations() {
        return new EJBConfigurationDAO(this.hbConfig).getEJBConfigurations();
    }

    public EJBProviderDO getEJBConfiguration(String beanJNDIName, String jnpProviderUrl) throws EJBConfigurationNotFoundException {
        return new EJBConfigurationDAO(this.hbConfig).getEJBConfiguration(beanJNDIName, jnpProviderUrl);
    }

    public void removeEJBConfiguration(String beanJNDIName, String jnpProviderUrl) throws EJBConfigurationNotFoundException {
        new EJBConfigurationDAO(this.hbConfig).deleteEJBConfiguration(beanJNDIName, jnpProviderUrl);
    }

    public Long addEJBAppServerConfiguration(EJBAppServerDO ejbAppServerDO) throws EJBAppServerAlreadyExistsException {
        try {
            return new EJBAppServerDAO(this.hbConfig).create(ejbAppServerDO);
        }
        catch (DuplicateEntityException e) {
            throw new EJBAppServerAlreadyExistsException(e);
        }
    }

    public EJBAppServerDO[] getEJBAppServerConfigurations() {
        return new EJBAppServerDAO(this.hbConfig).getEJBAppServers();
    }

    public EJBAppServerDO getEJBAppServerConfiguration(String jnpProviderUrl) {
        return new EJBAppServerDAO(this.hbConfig).getEJBAppServer(jnpProviderUrl);
    }

    public void removeEJBAppServerConfiguration(String jnpProviderUrl) throws EJBAppServerNotFoundException {
        new EJBAppServerDAO(this.hbConfig).deleteEJBAppServer(jnpProviderUrl);
    }

    public void restoreDefaults() {
    }
}

