/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.AbstractAppServerInstaller;
import org.wso2.wsas.installer.GenericInstaller;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;
import org.wso2.wsas.serverinfo.GenericServerInfo;
import org.wso2.wsas.serverinfo.Tomcat41xServerInfo;
import org.wso2.wsas.serverinfo.Tomcat5xServerInfo;
import org.wso2.wsas.serverinfo.Tomcat6xServerInfo;

public class TomcatInstaller
extends AbstractAppServerInstaller {
    private FileManipulator fileMan = new FileManipulator();
    private String serverInfoImplClass;
    private String serverXml;
    private static final String TOMCAT_4_1_X = "tomcat-4.1.x";
    private static final String TOMCAT_5_0_X = "tomcat-5.0.x";
    private static final String TOMCAT_5_5_X = "tomcat-5.5.x";
    private static final String TOMCAT_6_X = "tomcat-6.x";

    public void install() throws InstallationException {
        System.out.println("Please select your Tomcat version : ");
        String[] versions = this.getSupportedVersions();
        for (int i = 0; i < versions.length; ++i) {
            System.out.println(i + 1 + ". " + versions[i]);
        }
        int serverVersionIndex = this.getServerVersionIndex();
        String version = versions[serverVersionIndex];
        this.serverInfoImplClass = this.getServerInfoImplClasses()[serverVersionIndex];
        if (version.equals("other")) {
            new GenericInstaller().install();
            return;
        }
        if (this.serverHome != null && this.serverHome.trim().length() != 0 && !this.serverHome.equals("INVALID")) {
            System.out.print("Please enter your Tomcat Home directory [" + this.serverHome + "]: ");
        } else {
            System.out.print("Please enter your Tomcat Home directory : ");
        }
        this.serverHome = this.getAppServerHome();
        File tomcatHomeDir = new File(this.serverHome);
        if (!tomcatHomeDir.exists()) {
            String msg = "Tomcat home " + this.serverHome + " does not exist! Aborting installation.";
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
        if (this.serverHome.toLowerCase().indexOf("tomcat") == -1) {
            String response;
            System.out.print("[WARN] " + this.serverHome + " does not look like a Tomcat home directory.");
            System.out.print(" Do you want to continue (y/n)? [y]: ");
            do {
                try {
                    response = InputReader.readInput();
                }
                catch (IOException e) {
                    throw new InstallationException(e);
                }
            } while (!response.equalsIgnoreCase("y") && !response.equalsIgnoreCase("n") && response.trim().length() != 0);
            if (response.equalsIgnoreCase("n")) {
                System.out.println("[INFO] Installation aborted.");
                return;
            }
        }
        boolean isServerXMLReplaced = this.copyServerXML(this.serverHome, version);
        this.createWebArchive();
        this.copyWsasWAR(this.serverHome + File.separator + "webapps");
        if (version.equals(TOMCAT_4_1_X)) {
            try {
                File wso2wsasDir = new File(this.serverHome + File.separator + "webapps" + File.separator + "wso2wsas");
                if (!wso2wsasDir.mkdirs()) {
                    throw new InstallationException("Cannot create wso2wsas directory in webapps");
                }
                this.copyWsasWAR(this.serverHome + File.separator + "webapps" + File.separator + "wso2wsas");
                new ArchiveManipulator().extract(this.serverHome + File.separator + "webapps" + File.separator + "wso2wsas" + File.separator + "wso2wsas.war", this.serverHome + File.separator + "webapps" + File.separator + "wso2wsas");
                new File(this.serverHome + File.separator + "webapps" + File.separator + "wso2wsas" + File.separator + "wso2wsas.war").delete();
                this.fileMan.copyDir(new File("wso2wsastmp"), wso2wsasDir);
                this.fileMan.copyFile(new File("conf" + File.separator + "log4j.properties"), new File(this.serverHome + File.separator + "common" + File.separator + "classes" + File.separator + "log4j.properties"));
                String wso2utilsJar = this.getItem("lib", "wso2utils-", ".jar");
                this.fileMan.copyFile(new File("lib" + File.separator + wso2utilsJar), new File(this.serverHome + File.separator + "common" + File.separator + "lib" + File.separator + wso2utilsJar));
                this.copyDerbyJAR(this.serverHome + File.separator + "shared" + File.separator + "lib");
            }
            catch (IOException e) {
                throw new InstallationException("Cannot create Tomcat 4.x specific directories & files.");
            }
        }
        if (version.equals(TOMCAT_6_X)) {
            this.copyDerbyJAR(this.serverHome + File.separator + File.separator + "lib");
            this.copyLog4jJAR(this.serverHome + File.separator + File.separator + "lib");
        } else {
            this.copyDerbyJAR(this.serverHome + File.separator + "common" + File.separator + "lib");
            this.copyLog4jJAR(this.serverHome + File.separator + "common" + File.separator + "lib");
        }
        if (isServerXMLReplaced) {
            System.out.println("WSO2 WSAS was successfully installed on Tomcat (" + this.serverHome + ")");
        } else {
            System.out.println("\nWSO2 WSAS installation was successful.\nPlease configure your Tomcat server.xml as described in the README.txt file.\n");
        }
    }

    private boolean copyServerXML(String tomcatHome, String version) throws InstallationException {
        boolean serverXMLReplaced = false;
        String ourServerXML = this.getOurServerXML(version);
        try {
            AXIOMXPath xp;
            OMAttribute ksFileAttrib;
            AXIOMXPath xp1;
            SimpleNamespaceContext nsCtx;
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(ourServerXML));
            StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)parser);
            OMElement docEle = builder.getDocumentElement();
            OMElement serviceEle = docEle.getFirstChildWithName(new QName("Service"));
            if (version.equals(TOMCAT_4_1_X)) {
                Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
                while (iter.hasNext()) {
                    OMElement omEle = (OMElement)iter.next();
                    OMAttribute schemeAttr = omEle.getAttribute(new QName("scheme"));
                    if (schemeAttr == null || !schemeAttr.getAttributeValue().equalsIgnoreCase("https")) continue;
                    OMElement factoryEle = omEle.getFirstChildWithName(new QName("Factory"));
                    factoryEle.getAttribute(new QName("keystoreFile")).setAttributeValue(this.wso2wsasHome + File.separator + "conf" + File.separator + "wso2wsas.jks");
                    break;
                }
                nsCtx = new SimpleNamespaceContext();
                AXIOMXPath xp2 = new AXIOMXPath("//Service/Engine/Host/Context/ResourceParams/parameter/value[text()='jdbc:derby:${wso2wsas.home}/database/WSO2WSAS_DB']");
                xp2.setNamespaceContext((NamespaceContext)nsCtx);
                OMElement omElement = (OMElement)xp2.selectSingleNode((Object)docEle);
                omElement.setText("jdbc:derby:" + this.wso2wsasHome + "/database/WSO2WSAS_DB");
            } else if (version.equals(TOMCAT_5_5_X) || version.equals(TOMCAT_6_X)) {
                nsCtx = new SimpleNamespaceContext();
                xp1 = new AXIOMXPath("//Service/Connector/@keystoreFile");
                xp1.setNamespaceContext((NamespaceContext)nsCtx);
                ksFileAttrib = (OMAttribute)xp1.selectSingleNode((Object)docEle);
                ksFileAttrib.setAttributeValue(this.wso2wsasHome + File.separator + "conf" + File.separator + "wso2wsas.jks");
                xp = new AXIOMXPath("//Service/Engine/Host/Context/Resource/@url");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                OMAttribute attrib = (OMAttribute)xp.selectSingleNode((Object)docEle);
                attrib.setAttributeValue("jdbc:derby:" + this.wso2wsasHome + "/database/WSO2WSAS_DB");
            } else if (version.equals(TOMCAT_5_0_X)) {
                nsCtx = new SimpleNamespaceContext();
                xp1 = new AXIOMXPath("//Service/Connector/@keystoreFile");
                xp1.setNamespaceContext((NamespaceContext)nsCtx);
                ksFileAttrib = (OMAttribute)xp1.selectSingleNode((Object)docEle);
                ksFileAttrib.setAttributeValue(this.wso2wsasHome + File.separator + "conf" + File.separator + "wso2wsas.jks");
                xp = new AXIOMXPath("//Service/Engine/Host/Context/ResourceParams/parameter/value[text()='jdbc:derby:${wso2wsas.home}/database/WSO2WSAS_DB']");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                OMElement omElement = (OMElement)xp.selectSingleNode((Object)docEle);
                omElement.setText("jdbc:derby:" + this.wso2wsasHome + "/database/WSO2WSAS_DB");
            }
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileWriter(ourServerXML));
            docEle.serialize(writer);
        }
        catch (Exception e) {
            String msg = "Could not modify server.xml file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
        try {
            File tomcatConfDir = new File(tomcatHome + File.separator + "conf");
            System.out.println("Copying \"conf/tomcat/server.xml\" to \"" + tomcatConfDir.getAbsolutePath() + "\"");
            this.serverXml = tomcatConfDir.getAbsolutePath() + File.separator + "server.xml";
            File tomcatServerXML = new File(this.serverXml);
            if (tomcatServerXML.exists()) {
                String replace;
                do {
                    System.out.println("\nWSO2 WSAS requires HTTPS to be enabled for the administration services and the WSO2 WSAS datasource to be configured for the WSO2 WSAS Database.\nYou can either add this to the " + tomcatConfDir.getAbsolutePath() + File.separator + "server.xml" + " yourself," + " or we provide a default server.xml with HTTPS enabled, " + "and datasource configured.\n" + "If you use our server.xml, the installer will backup the" + " original " + tomcatConfDir.getAbsolutePath() + File.separator + "server.xml.");
                    System.out.print("Do you want to replace the " + tomcatConfDir.getAbsolutePath() + File.separator + "conf" + File.separator + "server.xml file(y/n)? [n]: ");
                } while (!(replace = InputReader.readInput()).equalsIgnoreCase("y") && !replace.equalsIgnoreCase("n") && replace.trim().length() != 0);
                if (replace.equalsIgnoreCase("y")) {
                    File origServerXML = new File(tomcatConfDir.getAbsolutePath() + File.separator + "server.xml");
                    String backedupServerXML = "server-" + System.currentTimeMillis() + ".xml.bak";
                    this.fileMan.copyFile(origServerXML, new File(tomcatConfDir.getAbsolutePath() + File.separator + backedupServerXML));
                    System.out.println("[INFO] The original " + tomcatConfDir.getAbsolutePath() + File.separator + "conf" + File.separator + "server.xml " + "was backed up as " + tomcatConfDir.getAbsolutePath() + File.separator + "conf" + File.separator + backedupServerXML);
                    tomcatServerXML.delete();
                    this.fileMan.copyFile(new File(ourServerXML), tomcatServerXML);
                    serverXMLReplaced = true;
                }
            } else {
                serverXMLReplaced = true;
                this.fileMan.copyFile(new File(ourServerXML), tomcatServerXML);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy Tomcat server.xml file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
        return serverXMLReplaced;
    }

    private String getOurServerXML(String version) throws InstallationException {
        String ourServerXML;
        if (version.indexOf("tomcat-4.") == 0) {
            ourServerXML = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "tomcat" + File.separator + "4.x" + File.separator + "server.xml";
        } else if (version.indexOf("tomcat-5.5") == 0) {
            ourServerXML = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "tomcat" + File.separator + "5.5.x" + File.separator + "server.xml";
        } else if (version.indexOf("tomcat-5.0") == 0) {
            ourServerXML = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "tomcat" + File.separator + "5.0.x" + File.separator + "server.xml";
        } else if (version.indexOf("tomcat-6") == 0) {
            ourServerXML = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "tomcat" + File.separator + "6.x" + File.separator + "server.xml";
        } else {
            throw new InstallationException("Unsupported Tomcat version");
        }
        return ourServerXML;
    }

    public String getDescription() {
        return "Tomcat Server";
    }

    public String getId() {
        return "1";
    }

    public String[] getSupportedVersions() {
        return new String[]{TOMCAT_4_1_X, TOMCAT_5_0_X, TOMCAT_5_5_X, TOMCAT_6_X, "other"};
    }

    public String[] getServerInfoImplClasses() {
        return new String[]{Tomcat41xServerInfo.class.getName(), Tomcat5xServerInfo.class.getName(), Tomcat5xServerInfo.class.getName(), Tomcat6xServerInfo.class.getName(), GenericServerInfo.class.getName()};
    }

    public String getServerInfoImplClass() {
        return this.serverInfoImplClass;
    }

    public Properties getServerProperties() {
        Properties props = new Properties();
        String serverXml = this.serverXml;
        if (File.separatorChar == '\\') {
            serverXml = serverXml.replace('\\', '/');
        }
        props.setProperty("tomcat.server.xml", serverXml);
        return props;
    }
}

