/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.IOException;
import org.wso2.utils.AntBuildException;
import org.wso2.utils.AntBuildInvoker;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.GenericInstaller;
import org.wso2.wsas.installer.GeronimoInstaller;
import org.wso2.wsas.installer.Installable;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallationManager;
import org.wso2.wsas.installer.InstallationMode;
import org.wso2.wsas.installer.InstallerConstants;
import org.wso2.wsas.installer.JBossInstaller;
import org.wso2.wsas.installer.TomcatInstaller;

public class ServletContainerInstallationMode
implements InstallationMode {
    private static final TomcatInstaller tomcatInstaller = new TomcatInstaller();
    private static final JBossInstaller jbossInstaller = new JBossInstaller();
    private static final GeronimoInstaller geronimoInstaller = new GeronimoInstaller();
    private static final GenericInstaller genericInstaller = new GenericInstaller();
    private static final Installable[] INSTALLABLES = new Installable[]{tomcatInstaller, jbossInstaller, geronimoInstaller, genericInstaller};
    private String wsasVersion;
    private String[] envVariables;

    public void setWsasVersion(String wsasVersion) {
        this.wsasVersion = wsasVersion;
    }

    public void setEnvVariables(String[] envVariables) {
        this.envVariables = envVariables;
    }

    public void doInstallation() {
        String wsasHome = InstallationManager.getWSASHome();
        System.setProperty("wso2wsas.home", wsasHome);
        String javaHome = "";
        for (int i = 0; i < this.envVariables.length; ++i) {
            String arg = this.envVariables[i];
            if (arg.equals("-tomcat_home")) {
                if (++i >= this.envVariables.length) continue;
                tomcatInstaller.setServerHome(this.envVariables[i]);
                continue;
            }
            if (arg.equals("-jboss_home")) {
                if (++i >= this.envVariables.length) continue;
                jbossInstaller.setServerHome(this.envVariables[i]);
                continue;
            }
            if (arg.equals("-geronimo_home")) {
                if (++i >= this.envVariables.length) continue;
                geronimoInstaller.setServerHome(this.envVariables[i]);
                continue;
            }
            if (!arg.equals("-java_home") || ++i >= this.envVariables.length) continue;
            javaHome = this.envVariables[i];
        }
        System.out.println("Using Java Home : " + javaHome + "\n");
        String installerZip = "wso2wsas-core-" + this.wsasVersion + "-installer" + ".zip";
        try {
            new ArchiveManipulator().extract("lib" + File.separator + installerZip, "wso2wsastmp");
        }
        catch (IOException e) {
            System.err.println("Cannot extract " + installerZip + " " + e);
            e.printStackTrace();
            System.exit(1);
        }
        AntBuildInvoker buildInvoker = new AntBuildInvoker(new File(InstallerConstants.INSTALLER_TMP_DIR + File.separator + "build.xml"));
        try {
            buildInvoker.invokeDefaultTarget(false);
        }
        catch (AntBuildException e) {
            e.printStackTrace();
            System.err.println("Installation failed " + (Object)((Object)e));
            System.exit(1);
        }
        try {
            Installable installable = this.selectAppServer();
            installable.setWSASHome(wsasHome);
            installable.setJavaHome(javaHome);
            installable.install();
            buildInvoker.invokeTarget("clean", false);
        }
        catch (Exception e) {
            System.err.println(" Installation failed : " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getDescription() {
        return "Servlet Container Installation";
    }

    public String toString() {
        return this.getDescription();
    }

    private Installable selectAppServer() throws InstallationException {
        System.out.println("Please select your application server:");
        for (int i = 0; i < INSTALLABLES.length; ++i) {
            Installable installable = INSTALLABLES[i];
            System.out.println(installable.getId() + ". " + installable.getDescription());
        }
        boolean foundValidServer = false;
        Installable installable = null;
        block3: while (!foundValidServer) {
            String serverId;
            System.out.print(": ");
            try {
                serverId = InputReader.readInput();
            }
            catch (IOException e) {
                throw new InstallationException(e);
            }
            for (int i = 0; i < INSTALLABLES.length; ++i) {
                if (!serverId.equals(INSTALLABLES[i].getId())) continue;
                foundValidServer = true;
                installable = INSTALLABLES[i];
                continue block3;
            }
        }
        System.out.println();
        System.out.println("Installing on " + installable.getDescription() + "...");
        return installable;
    }
}

