/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.AbstractAppServerInstaller;
import org.wso2.wsas.installer.GenericInstaller;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;
import org.wso2.wsas.serverinfo.GenericServerInfo;
import org.wso2.wsas.serverinfo.JBossServerInfo;

public class JBossInstaller
extends AbstractAppServerInstaller {
    private FileManipulator fileMan = new FileManipulator();
    private String configurationFileSet;
    private String serverInfoImplClass;
    private String tomcatServerXml;

    public void install() throws InstallationException {
        String jbossServerDirName;
        String[] configFileSets;
        System.out.println("Please select your JBoss version : ");
        String[] versions = this.getSupportedVersions();
        for (int i = 0; i < versions.length; ++i) {
            System.out.println(i + 1 + ". " + versions[i]);
        }
        int serverVersionIndex = this.getServerVersionIndex();
        String version = versions[serverVersionIndex];
        this.serverInfoImplClass = this.getServerInfoImplClasses()[serverVersionIndex];
        if (version.equals("other")) {
            new GenericInstaller().install();
            return;
        }
        if (this.serverHome != null && this.serverHome.trim().length() != 0 && !this.serverHome.equals("INVALID")) {
            System.out.print("Please enter your JBoss Home directory [" + this.serverHome + "]: ");
        } else {
            System.out.print("Please enter your JBoss Home directory : ");
        }
        this.serverHome = this.getAppServerHome();
        File jbossHomeDir = new File(this.serverHome);
        if (!jbossHomeDir.exists()) {
            String msg = "JBoss home " + this.serverHome + " does not exist! Aborting installation.";
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
        if (this.serverHome.toLowerCase().indexOf("jboss") == -1) {
            String response;
            System.out.print("[WARN] " + this.serverHome + " does not look like a JBoss home directory.");
            System.out.print(" Do you want to continue (y/n)? [y]: ");
            do {
                try {
                    response = InputReader.readInput();
                }
                catch (IOException e) {
                    throw new InstallationException(e);
                }
            } while (!response.equalsIgnoreCase("y") && !response.equalsIgnoreCase("n") && response.trim().length() != 0);
            if (response.equalsIgnoreCase("n")) {
                System.out.println("[INFO] Installation aborted.");
                return;
            }
        }
        if ((configFileSets = new File(jbossServerDirName = this.serverHome + File.separator + "server").list()).length == 0) {
            System.out.println(" No configuration file sets found!");
            System.exit(1);
        }
        System.out.println("Please select the configuration file set you wish to use:");
        for (int i = 0; i < configFileSets.length; ++i) {
            System.out.println(i + 1 + ". " + configFileSets[i]);
        }
        int configFileSetIndex = -1;
        do {
            System.out.print(": ");
            try {
                configFileSetIndex = Integer.parseInt(InputReader.readInput()) - 1;
            }
            catch (IOException e) {
                throw new InstallationException(e);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        } while (configFileSetIndex == -1 || configFileSetIndex >= configFileSets.length);
        this.configurationFileSet = configFileSets[configFileSetIndex];
        String jbossDeploymentDir = this.serverHome + File.separator + "server" + File.separator + this.configurationFileSet + File.separator + "deploy";
        File jbossDeployDir = new File(jbossDeploymentDir);
        while (!jbossDeployDir.exists()) {
            System.out.println("[WARN] " + jbossDeployDir.getAbsolutePath() + " does not exist.");
            System.out.print("Please specify the deployment directory : ");
            jbossDeploymentDir = "";
            while (jbossDeploymentDir == null || jbossDeploymentDir.trim().length() == 0) {
                try {
                    jbossDeploymentDir = InputReader.readInput();
                    jbossDeployDir = new File(jbossDeploymentDir);
                }
                catch (IOException e) {
                    throw new InstallationException(e);
                }
            }
        }
        this.copyDerbyDsXml(jbossDeploymentDir);
        boolean isServerXMLReplaced = this.copyServerXML(this.serverHome);
        this.createWebArchive();
        this.copyWsasWAR(jbossDeploymentDir);
        this.copyDerbyJAR(jbossDeploymentDir + File.separator + ".." + File.separator + "lib");
        if (isServerXMLReplaced) {
            System.out.println("WSO2 WSAS was successfully installed on JBoss (" + this.serverHome + ")");
        } else {
            System.out.println("\nWSO2 WSAS installation was successful.\nPlease configure your JBoss server.xml as described in the README.txt file.\n");
        }
    }

    private boolean copyServerXML(String jbossHome) throws InstallationException {
        boolean serverXMLReplaced = false;
        try {
            File deployDir = new File(jbossHome + File.separator + "server" + File.separator + this.configurationFileSet + File.separator + "deploy");
            File tomcatConfDir = null;
            String[] dirs = deployDir.list();
            boolean foundTomcat = false;
            for (int i = 0; i < dirs.length; ++i) {
                String dir = dirs[i];
                if (!dir.startsWith("jbossweb-tomcat") || !dir.endsWith(".sar")) continue;
                foundTomcat = true;
                tomcatConfDir = new File(deployDir + File.separator + dir);
                break;
            }
            if (!foundTomcat) {
                throw new InstallationException("Tomcat not found");
            }
            System.out.println("Copying \"server.xml\" to \"" + tomcatConfDir.getAbsolutePath() + "\"");
            this.tomcatServerXml = tomcatConfDir.getAbsolutePath() + File.separator + "server.xml";
            File tomcatServerXML = new File(this.tomcatServerXml);
            if (tomcatServerXML.exists()) {
                String delete;
                do {
                    System.out.println("\nWSO2 WSAS requires HTTPS to be enabled for the administration services and the WSO2 WSAS datasource to be configured for the WSO2 WSAS Database.\nYou can either add this to the " + tomcatServerXML.getAbsolutePath() + " yourself," + " \nor we provide a default server.xml with HTTPS enabled, " + "and datasource configured.\n" + "If you use our server.xml, the installer will backup the" + " original " + tomcatServerXML.getAbsolutePath());
                    System.out.print("Do you want to replace the " + tomcatServerXML.getAbsolutePath() + " file(y/n)? [n]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y")) {
                    File origServerXML = new File(tomcatConfDir.getAbsolutePath() + File.separator + "server.xml");
                    String backedupServerXML = "server-" + System.currentTimeMillis() + ".xml.bak";
                    this.fileMan.copyFile(origServerXML, new File(tomcatConfDir.getAbsolutePath() + File.separator + backedupServerXML));
                    System.out.println("[INFO] The original " + tomcatServerXML.getAbsolutePath() + " was backed up as " + tomcatConfDir.getAbsolutePath() + File.separator + backedupServerXML);
                    tomcatServerXML.delete();
                    String ourServerXML = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "jboss" + File.separator + "server.xml";
                    try {
                        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(ourServerXML));
                        StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)parser);
                        OMElement docEle = builder.getDocumentElement();
                        OMElement serviceEle = docEle.getFirstChildWithName(new QName("Service"));
                        Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
                        while (iter.hasNext()) {
                            OMElement omEle = (OMElement)iter.next();
                            OMAttribute ksfAttr = omEle.getAttribute(new QName("keystoreFile"));
                            if (ksfAttr == null) continue;
                            ksfAttr.setAttributeValue(this.wso2wsasHome + File.separator + "conf" + File.separator + "wso2wsas.jks");
                            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileWriter(ourServerXML));
                            docEle.serialize(writer);
                            break;
                        }
                    }
                    catch (XMLStreamException e) {
                        String msg = "Could not modify server.xml file: " + e;
                        System.err.println(" " + msg);
                        throw new InstallationException(msg, e);
                    }
                    this.fileMan.copyFile(new File(ourServerXML), tomcatServerXML);
                    serverXMLReplaced = true;
                }
            } else {
                serverXMLReplaced = true;
                this.fileMan.copyFile(new File(InstallerConstants.APPSERVER_TMP_DIR + File.separator + "jboss" + File.separator + "server.xml"), tomcatServerXML);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy server.xml file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
        return serverXMLReplaced;
    }

    private void copyDerbyDsXml(String jbossDeploymentDir) throws InstallationException {
        try {
            File dst = new File(jbossDeploymentDir + File.separator + "wso2wsas-derby-ds.xml");
            System.out.println("Copying \"wso2wsas-derby-ds.xml\" to \"" + dst.getAbsolutePath() + "\"");
            this.fileMan.copyFile(new File(InstallerConstants.APPSERVER_TMP_DIR + File.separator + "jboss" + File.separator + "wso2wsas-derby-ds.xml"), dst);
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy wso2wsas-derby-ds.xml : " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }

    public String getDescription() {
        return "JBoss Server";
    }

    public String getId() {
        return "2";
    }

    public String[] getSupportedVersions() {
        return new String[]{"jboss-3.2.x", "jboss-4.0.x", "other"};
    }

    public String[] getServerInfoImplClasses() {
        return new String[]{JBossServerInfo.class.getName(), JBossServerInfo.class.getName(), GenericServerInfo.class.getName()};
    }

    public String getServerInfoImplClass() {
        return this.serverInfoImplClass;
    }

    public Properties getServerProperties() {
        Properties props = new Properties();
        props.setProperty("jboss.config.file.set", this.configurationFileSet);
        String tomcatServerXml = this.tomcatServerXml;
        if (File.separatorChar == '\\') {
            tomcatServerXml = tomcatServerXml.replace('\\', '/');
        }
        props.setProperty("tomcat.server.xml", tomcatServerXml);
        return props;
    }
}

