/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.EclipseWtpPluginInstalltionMode;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallationMode;
import org.wso2.wsas.installer.ServletContainerInstallationMode;
import org.wso2.wsas.installer.WindowsNtServiceInstallation;
import org.wso2.wsas.installer.WindowsNtServiceUninstallation;

public class InstallationManager {
    private static final ServletContainerInstallationMode scInstMode = new ServletContainerInstallationMode();
    private static final EclipseWtpPluginInstalltionMode eclipsePluginInstMode = new EclipseWtpPluginInstalltionMode();
    private static final WindowsNtServiceInstallation ntServiceInstMode = new WindowsNtServiceInstallation();
    private static final WindowsNtServiceUninstallation ntServiceUninstMode = new WindowsNtServiceUninstallation();
    private final InstallationMode[] INSTALLATION_MODES;

    public InstallationManager() {
        String osName = System.getProperty("os.name");
        this.INSTALLATION_MODES = osName.toLowerCase().indexOf("win") != -1 ? new InstallationMode[]{eclipsePluginInstMode, scInstMode, ntServiceInstMode, ntServiceUninstMode} : new InstallationMode[]{eclipsePluginInstMode, scInstMode};
    }

    private void doInstallation(String[] params) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("bin" + File.separator + "version.txt"));
        }
        catch (IOException e) {
            System.err.println("Cannot load version.txt file " + e);
            e.printStackTrace();
            System.exit(1);
        }
        String wsasVersion = props.getProperty("version");
        System.out.println("\n###########################################################");
        System.out.println("#                                                         #");
        System.out.println("#               WSO2 WSAS v" + wsasVersion + " Installation               #");
        System.out.println("#                                                         #");
        System.out.println("###########################################################\n");
        scInstMode.setEnvVariables(params);
        scInstMode.setWsasVersion(wsasVersion);
        try {
            int installationMode = this.getInstallationMode();
            this.INSTALLATION_MODES[installationMode].doInstallation();
        }
        catch (InstallationException e) {
            System.err.println(" Installation failed : " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new InstallationManager().doInstallation(args);
    }

    public static String getWSASHome() {
        File defaultWSASHome = new File(System.getProperty("user.home") + File.separator + ".wso2wsas");
        System.out.println("WSO2 WSAS Home directory is where the WSO2 WSAS database, conf files, logs, and module & service repository will reside.");
        String wsasHome = defaultWSASHome.getAbsolutePath();
        while (true) {
            System.out.print("Please enter the WSO2 WSAS Home directory [" + defaultWSASHome.getAbsolutePath() + "]:");
            try {
                wsasHome = InputReader.readInput();
                if (wsasHome == null || wsasHome.trim().length() == 0) {
                    wsasHome = defaultWSASHome.getAbsolutePath();
                } else {
                    if (wsasHome.startsWith("~")) {
                        System.err.println("Please specify the path properly. The '~' character is not supported");
                        continue;
                    }
                    if (new File(wsasHome).getCanonicalPath().equals(new File(".").getCanonicalPath())) {
                        System.err.println("You cannot install WSO2 WSAS into this directory. Please specify another directory.");
                        continue;
                    }
                }
            }
            catch (IOException e) {
                System.err.println(" Could not read WSO2 WSAS Home : " + e);
                System.exit(1);
            }
            File file = new File(wsasHome);
            if (!file.isFile()) break;
            System.err.println("WSO2 WSAS Home " + wsasHome + " is a file not a directory!");
        }
        return wsasHome.trim();
    }

    private int getInstallationMode() throws InstallationException {
        System.out.println("\nPlease select your installation mode: ");
        for (int i = 0; i < this.INSTALLATION_MODES.length; ++i) {
            System.out.println(i + 1 + ") " + this.INSTALLATION_MODES[i].getDescription());
        }
        int modeId = 0;
        while (true) {
            System.out.print(": ");
            try {
                modeId = Integer.parseInt(InputReader.readInput());
            }
            catch (Exception e) {
                System.err.println("Please enter a valid mode");
            }
            if (modeId > 0 && modeId <= this.INSTALLATION_MODES.length) break;
            System.err.println("Please enter a valid mode");
        }
        System.out.println();
        System.out.println("Selection: " + this.INSTALLATION_MODES[modeId - 1]);
        return modeId - 1;
    }
}

