/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.AbstractAppServerInstaller;
import org.wso2.wsas.installer.GenericInstaller;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;
import org.wso2.wsas.serverinfo.GenericServerInfo;
import org.wso2.wsas.serverinfo.GeronimoServerInfo;

public class GeronimoInstaller
extends AbstractAppServerInstaller {
    private String configXml;
    private static final String GERONIMO_PLAN_NAMESPACE = "http://geronimo.apache.org/xml/ns/j2ee/connector-1.1";

    public void install() throws InstallationException {
        System.out.println("Please select your Geronimo version : ");
        String[] versions = this.getSupportedVersions();
        for (int i = 0; i < versions.length; ++i) {
            System.out.println(i + 1 + ". " + versions[i]);
        }
        int serverVersionIndex = this.getServerVersionIndex();
        String version = versions[serverVersionIndex];
        if (version.equals("other")) {
            new GenericInstaller().install();
            return;
        }
        if (this.serverHome != null && this.serverHome.trim().length() != 0 && !this.serverHome.equals("INVALID")) {
            System.out.print("Please enter your Geronimo Home directory [" + this.serverHome + "]: ");
        } else {
            System.out.print("Please enter your Geronimo Home directory : ");
        }
        this.serverHome = this.getAppServerHome();
        File geronimoHomeDir = new File(this.serverHome);
        if (!geronimoHomeDir.exists()) {
            String msg = "Geronimo home " + this.serverHome + " does not exist! Aborting installation.";
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
        if (this.serverHome.toLowerCase().indexOf("geronimo") == -1) {
            String response;
            System.out.print("[WARN] " + this.serverHome + " does not look like a Geronimo home directory.");
            System.out.print(" Do you want to continue (y/n)? [y]: ");
            do {
                try {
                    response = InputReader.readInput();
                }
                catch (IOException e) {
                    throw new InstallationException(e);
                }
            } while (!response.equalsIgnoreCase("y") && !response.equalsIgnoreCase("n") && response.trim().length() != 0);
            if (response.equalsIgnoreCase("n")) {
                System.out.println("[INFO] Installation aborted.");
                return;
            }
        }
        this.configXml = geronimoHomeDir.getAbsolutePath() + File.separator + "var" + File.separator + "config" + File.separator + "config.xml";
        this.createWebArchive();
        try {
            String geronimoPassword;
            String geronimoUsername;
            String os = System.getProperty("os.version");
            System.out.print("Going to run Geronimo deployer tool.\nPlease make sure the Geronimo server is running & press enter");
            InputReader.readInput();
            System.out.println();
            do {
                System.out.print("Geronimo Admin Username :");
            } while ((geronimoUsername = InputReader.readInput()) == null || geronimoUsername.trim().length() == 0);
            while ((geronimoPassword = InputReader.readPassword((String)"Geronimo Admin User Password :")) == null || geronimoPassword.length() == 0) {
            }
            String script = os.toLowerCase().indexOf("win") != -1 ? "deploy.bat" : "deploy.sh";
            String planXml = InstallerConstants.APPSERVER_TMP_DIR + File.separator + "geronimo" + File.separator + "wso2wsas-geronimo-plan.xml";
            this.updatePlanXml(planXml);
            System.out.println("Deploying the plan XML file");
            String deployPlanCmd = geronimoHomeDir.getAbsolutePath() + File.separator + "bin" + File.separator + script + " --user " + geronimoUsername + " --password " + geronimoPassword + " deploy " + planXml + " " + geronimoHomeDir.getAbsolutePath() + File.separator + "repository" + File.separator + "tranql" + File.separator + "tranql-connector" + File.separator + "1.2" + File.separator + "tranql-connector-1.2.rar";
            Process deployPlanProcess = Runtime.getRuntime().exec(deployPlanCmd);
            this.printOutput(deployPlanProcess);
            if (deployPlanProcess.waitFor() != 0) {
                throw new InstallationException("Geronimo deployer failed");
            }
            System.out.println("OK");
            System.out.println("Deploying the wso2wsas.war file");
            String deployWarCmd = geronimoHomeDir.getAbsolutePath() + File.separator + "bin" + File.separator + script + " --user " + geronimoUsername + " --password " + geronimoPassword + " deploy " + InstallerConstants.WSO2WSAS_WAR;
            Process deployWarProcess = Runtime.getRuntime().exec(deployWarCmd);
            this.printOutput(deployWarProcess);
            if (deployWarProcess.waitFor() != 0) {
                throw new InstallationException("Geronimo deployer failed");
            }
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InstallationException(" Cannot run Geronimo deployer. \nPlease make sure that the Geronimo server is running.", e);
        }
        System.out.println("WSO2 WSAS was successfully installed on Geronimo (" + this.serverHome + ")");
    }

    private void updatePlanXml(String planXml) throws XMLStreamException, JaxenException, IOException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(new File(planXml)));
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(parser);
        OMElement docEle = staxOMBuilder.getDocumentElement();
        OMElement omElement = this.getOMElement("//ns:config-property-setting[@name='ConnectionURL']", docEle);
        omElement.setText("jdbc:derby:" + this.wso2wsasHome + "/database/WSO2WSAS_DB");
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileWriter(planXml));
        docEle.serialize(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printOutput(Process process) throws IOException {
        BufferedReader reader = null;
        try {
            String op;
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((op = reader.readLine()) != null) {
                System.err.println(op);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public String getDescription() {
        return "Geronimo Server";
    }

    public String getId() {
        return "3";
    }

    public String[] getServerInfoImplClasses() {
        return new String[]{GeronimoServerInfo.class.getName(), GenericServerInfo.class.getName(), GenericServerInfo.class.getName()};
    }

    public String[] getSupportedVersions() {
        return new String[]{"geronimo-tomcat-1.1.1", "geronimo-jetty-1.1.1", "other"};
    }

    public String getServerInfoImplClass() {
        return GeronimoServerInfo.class.getName();
    }

    public Properties getServerProperties() {
        Properties props = new Properties();
        String configXml = this.configXml;
        if (File.separatorChar == '\\') {
            configXml = configXml.replace('\\', '/');
        }
        props.setProperty("geronimo.server.xml", configXml);
        props.setProperty("appserver.version", "1.1.1");
        return props;
    }

    private OMElement getOMElement(String xpathString, OMElement parentElement) throws JaxenException {
        XPath xpath = this.getXPath(xpathString);
        return (OMElement)xpath.selectSingleNode((Object)parentElement);
    }

    private XPath getXPath(String xpathString) throws JaxenException {
        SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
        nsCtx.addNamespace("ns", GERONIMO_PLAN_NAMESPACE);
        AXIOMXPath xpath = new AXIOMXPath(xpathString);
        xpath.setNamespaceContext((NamespaceContext)nsCtx);
        return xpath;
    }
}

