/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.AbstractInstaller;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;
import org.wso2.wsas.serverinfo.GenericServerInfo;

public class GenericInstaller
extends AbstractInstaller {
    private FileManipulator fileMan = new FileManipulator();

    public void install() throws InstallationException {
        String msg;
        File webappDir;
        String warDeploymentDir;
        block16: {
            System.out.println("Starting Generic installation...");
            warDeploymentDir = "";
            while (warDeploymentDir == null || warDeploymentDir.trim().length() == 0) {
                System.out.print("Please enter your Application Server's WAR file deployment directory : ");
                try {
                    warDeploymentDir = InputReader.readInput();
                }
                catch (IOException e) {
                    String msg2 = "Could not read WAR deployment directory";
                    System.err.println(" " + msg2);
                    throw new InstallationException(msg2, e);
                }
            }
            webappDir = new File(warDeploymentDir);
            if (!webappDir.exists()) {
                msg = warDeploymentDir + " does not exist. Create new directory? (y/n) ";
                System.out.print(" " + msg);
                try {
                    String ans = "";
                    while (!ans.equalsIgnoreCase("y") && !ans.equalsIgnoreCase("n")) {
                        ans = InputReader.readInput();
                    }
                    if (ans.equalsIgnoreCase("y")) {
                        if (!webappDir.mkdirs()) {
                            throw new InstallationException("Could not create directory " + warDeploymentDir);
                        }
                        break block16;
                    }
                    throw new InstallationException("Webapps directory does not exist. Aborting installation.");
                }
                catch (IOException e) {
                    throw new InstallationException(e);
                }
            }
        }
        if (!webappDir.isDirectory()) {
            msg = warDeploymentDir + " is not a directory";
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
        this.createWebArchive();
        try {
            System.out.println("Copying \"wso2wsas.war\" to \"" + webappDir.getAbsolutePath() + "\"");
            File warFile = new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas.war");
            if (warFile.exists()) {
                String delete;
                do {
                    System.out.print(warFile.getAbsolutePath() + " already exists. Do you want to replace this file(y/n)? [y]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    warFile.delete();
                    this.fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
                }
            } else {
                this.fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg3 = "Could not copy wso2wsas.war file: " + e;
            System.err.println(" " + msg3);
            throw new InstallationException(msg3);
        }
        System.out.println("\nWSO2 WSAS Servlet Edition installation was successful.\nPlease configure your J2EE app-server configuration files as described in the README.txt file.\n");
    }

    public String getDescription() {
        return "Generic Server";
    }

    public String getId() {
        return "4";
    }

    public String[] getSupportedVersions() {
        return new String[0];
    }

    public String getServerInfoImplClass() {
        return GenericServerInfo.class.getName();
    }

    public Properties getServerProperties() {
        return new Properties();
    }
}

