/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.IOException;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallationMode;

public class EclipseWtpPluginInstalltionMode
implements InstallationMode {
    private static FileManipulator fileMan = new FileManipulator();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doInstallation() throws InstallationException {
        System.out.println("\nStarting WSAS Eclipse WTP Plugin installation...");
        String wtpHomeDir = System.getProperty("WTP_HOME");
        System.out.println("Please shutdown the Eclipse instance, If Already Running ...");
        while (wtpHomeDir == null || wtpHomeDir.trim().length() == 0) {
            System.out.print("Please enter Eclipse WTP Home : ");
            try {
                wtpHomeDir = InputReader.readInput();
            }
            catch (IOException e) {
                String msg = "Could not read Eclipse WTP Home";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            }
        }
        File wtpDir = new File(wtpHomeDir);
        if (!wtpDir.exists()) {
            String msg = wtpHomeDir + " does not exist !! ";
            System.out.print(" " + msg);
            return;
        } else {
            File destination = new File(wtpHomeDir + File.separator + "plugins");
            if (EclipseWtpPluginInstalltionMode.validateEclipseWTPInstallation(destination)) {
                System.out.println("Using Eclipse WTP HOME [" + wtpHomeDir + "]");
                try {
                    System.out.println("Copying WSAS Eclipse WTP Plugins " + wtpDir.getAbsolutePath() + File.separator + "plugins");
                    File[] matchingFiles = fileMan.getMatchingFiles(destination.getAbsolutePath(), "org.eclipse.jst.ws.axis2", "jar");
                    for (int i = 0; i < matchingFiles.length; ++i) {
                        File file = matchingFiles[i];
                        if (!file.exists()) continue;
                        file.delete();
                    }
                    File[] matchingExistingWSFFiles = fileMan.getMatchingFiles(destination.getAbsolutePath(), "org.wso2.wsf", "jar");
                    if (matchingExistingWSFFiles.length > 0) {
                        String userInput;
                        do {
                            System.out.print("Previous version of WSAS Eclipse Plugins Exists,\n Uninstall previous version and install new version(y/n)? [y]: ");
                        } while (!(userInput = InputReader.readInput()).equalsIgnoreCase("y") && !userInput.equalsIgnoreCase("n") && userInput.trim().length() != 0);
                        if (userInput.equalsIgnoreCase("y") || userInput.trim().length() == 0) {
                            System.out.print(" Uninstalling the previous version of WSAS Eclipse Plugins ...");
                            for (int i = 0; i < matchingExistingWSFFiles.length; ++i) {
                                File file = matchingExistingWSFFiles[i];
                                if (!file.exists()) continue;
                                file.delete();
                            }
                            EclipseWtpPluginInstalltionMode.installWSASEclipsePlugins(".", destination);
                            return;
                        }
                        if (!userInput.equalsIgnoreCase("n")) return;
                        System.out.println("\nWSO2 WSAS Eclipse WTP Plugin installation canceled by user ...");
                        return;
                    }
                    EclipseWtpPluginInstalltionMode.installWSASEclipsePlugins(".", destination);
                    return;
                }
                catch (IOException e) {
                    String msg = "Could not copy WSAS Eclipse WTP Plugins: " + e;
                    System.err.println(" " + msg);
                    throw new InstallationException(msg);
                }
            } else {
                System.err.println("\nWSO2 WSAS Eclipse WTP Plugin installation failed.\nPlease select a valid Eclipse WTP Installation. \n");
            }
        }
    }

    private static boolean validateEclipseWTPInstallation(File wtpPluginDir) {
        File[] matchingJSTFiles = fileMan.getMatchingFiles(wtpPluginDir.getAbsolutePath(), "org.eclipse.jst", "jar");
        File[] matchingWSTFiles = fileMan.getMatchingFiles(wtpPluginDir.getAbsolutePath(), "org.eclipse.wst", "jar");
        return matchingJSTFiles.length > 0 && matchingWSTFiles.length > 0;
    }

    private static void installWSASEclipsePlugins(String wsasHome, File destination) throws IOException {
        File wsfDir = new File(wsasHome + File.separator + "lib" + File.separator + "wsf");
        File[] installableWSFPlugins = fileMan.getMatchingFiles(wsfDir.getAbsolutePath(), "org.wso2.wsf", "jar");
        for (int i = 0; i < installableWSFPlugins.length; ++i) {
            File checkFile = new File(destination + File.separator + installableWSFPlugins[i].getName());
            if (checkFile.exists()) {
                String delete;
                do {
                    System.out.print(checkFile.getAbsolutePath() + " already exists. Do you want to replace this file(y/n)? [y]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    checkFile.delete();
                }
            }
            fileMan.copyFile(installableWSFPlugins[i], checkFile);
        }
        System.out.println("OK");
        System.out.println("\nWSO2 WSAS Eclipse WTP Plugin installation was successful.\nPlease restart Eclipse WTP Instance.. \n");
    }

    public String getDescription() {
        return "Eclipse WTP Plugin Installation";
    }

    public String toString() {
        return this.getDescription();
    }
}

