/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.wsas.installer.Installable;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;

public abstract class AbstractInstaller
implements Installable {
    protected String serverHome;
    protected String wso2wsasHome;
    protected String javaHome;

    public void setServerHome(String serverHome) {
        this.serverHome = serverHome;
    }

    public String getServerHome() {
        return this.serverHome;
    }

    public String getWSASHome() {
        return this.wso2wsasHome;
    }

    public String setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this.javaHome;
    }

    public void setWSASHome(String wsasHome) {
        this.wso2wsasHome = wsasHome;
    }

    protected String getItem(String sourceDir, String itemPrefix, String extension) {
        File libDir = new File(sourceDir);
        String[] items = libDir.list();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (!item.startsWith(itemPrefix) || !item.endsWith(extension)) continue;
            return item;
        }
        return sourceDir;
    }

    protected void createWebArchive() throws InstallationException {
        try {
            System.out.println("Serializing wso2wsas.properties file ...");
            this.serializeWsasProperties(this.wso2wsasHome);
            System.out.println("OK");
            System.out.println("Creating Web Archive...");
            new ArchiveManipulator().archiveDir(InstallerConstants.WSO2WSAS_WAR, "wso2wsastmp" + File.separator + "lib" + File.separator + "wso2wsas");
            System.out.println("OK");
        }
        catch (IOException e) {
            throw new InstallationException(e);
        }
    }

    private void serializeWsasProperties(String wso2wsasHome) throws InstallationException {
        System.out.println("Creating wso2wsas.properties file...");
        File tmpDir = new File("wso2wsastmp" + File.separator + "lib" + File.separator + "wso2wsas" + File.separator + "WEB-INF" + File.separator + "classes");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        File wso2wsasPropFile = new File(tmpDir.getAbsolutePath() + File.separator + "wso2wsas.properties");
        BufferedWriter writer = null;
        try {
            if (wso2wsasPropFile.exists()) {
                wso2wsasPropFile.delete();
            }
            writer = new BufferedWriter(new FileWriter(wso2wsasPropFile));
            if (File.separatorChar == '\\') {
                wso2wsasHome = wso2wsasHome.replace(File.separatorChar, '/');
            }
            writer.write("wso2wsas.home=" + wso2wsasHome + "\n");
            writer.write("server.info.impl=" + this.getServerInfoImplClass() + "\n");
            Properties serverProps = this.getServerProperties();
            if (serverProps != null) {
                Iterator<Object> iter = serverProps.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    writer.write(key + "=" + serverProps.getProperty(key) + "\n");
                }
            }
            writer.flush();
        }
        catch (IOException e) {
            String msg = " Could not create wso2wsas.properties file :" + e;
            throw new InstallationException(msg);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    System.out.println("[WARN] Could not close BufferedWriter : " + e);
                }
            }
        }
    }
}

