/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.installer;

import java.io.File;
import java.io.IOException;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.InputReader;
import org.wso2.wsas.installer.AbstractInstaller;
import org.wso2.wsas.installer.InstallationException;
import org.wso2.wsas.installer.InstallerConstants;

public abstract class AbstractAppServerInstaller
extends AbstractInstaller {
    public static final String OTHER_VERSION = "other";
    private FileManipulator fileMan = new FileManipulator();

    protected int getServerVersionIndex() throws InstallationException {
        int version = -1;
        do {
            System.out.print(": ");
            try {
                version = Integer.parseInt(InputReader.readInput());
            }
            catch (IOException e) {
                String msg = "Cannot read " + this.getDescription() + " Version";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        } while (version == -1 || version == 0 || version > this.getSupportedVersions().length);
        return version - 1;
    }

    protected String getAppServerHome() throws InstallationException {
        String serverHome = "";
        while (serverHome == null || serverHome.trim().length() == 0) {
            try {
                serverHome = InputReader.readInput();
                if (serverHome != null && serverHome.trim().length() != 0) break;
                if (this.serverHome == null || this.serverHome.trim().length() == 0) continue;
                serverHome = this.serverHome;
                break;
            }
            catch (IOException e) {
                String msg = "Cannot read " + this.getDescription() + " Home";
                System.err.println(" " + msg);
                throw new InstallationException(msg, e);
            }
        }
        return serverHome.trim();
    }

    protected void copyDerbyJAR(String toDir) throws InstallationException {
        try {
            File libDir = new File(toDir);
            String derbyJar = this.getItem("lib", "derby-", ".jar");
            System.out.println("Copying \"lib/" + derbyJar + "\" to \"" + libDir.getAbsolutePath() + "\"");
            File destDerbyJar = new File(libDir.getAbsolutePath() + File.separator + derbyJar);
            if (destDerbyJar.exists()) {
                String delete;
                do {
                    System.out.print("The Tomcat \"" + destDerbyJar.getAbsolutePath() + "\" already exists. " + "Do you want to replace this file(y/n)? [y]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    destDerbyJar.delete();
                    this.fileMan.copyFile(new File("lib" + File.separator + derbyJar), destDerbyJar);
                }
            } else {
                this.fileMan.copyFile(new File("lib" + File.separator + derbyJar), destDerbyJar);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy derby.jar file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }

    protected void copyLog4jJAR(String toDir) throws InstallationException {
        try {
            File libDir = new File(toDir);
            System.out.println("Copying \"lib/log4j.jar\" to \"" + libDir.getAbsolutePath() + "\"");
            String log4jJar = this.getItem("lib", "log4j-", ".jar");
            File destLog4jJar = new File(libDir.getAbsolutePath() + File.separator + log4jJar);
            if (destLog4jJar.exists()) {
                String delete;
                do {
                    System.out.print("The Tomcat \"" + destLog4jJar.getAbsolutePath() + "\" already exists. " + "Do you want to replace this file(y/n)? [y]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    destLog4jJar.delete();
                    this.fileMan.copyFile(new File("lib" + File.separator + log4jJar), destLog4jJar);
                }
            } else {
                this.fileMan.copyFile(new File("lib" + File.separator + log4jJar), destLog4jJar);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy log4j.jar file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg, e);
        }
    }

    protected void copyWsasWAR(String webappsDir) throws InstallationException {
        File webappDir = new File(webappsDir);
        try {
            System.out.println("Copying \"wso2wsas.war\" to \"" + webappDir.getAbsolutePath() + "\"...");
            File warFile = new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas.war");
            if (warFile.exists()) {
                String delete;
                do {
                    System.out.print(warFile.getAbsolutePath() + " already exists. Do you want to replace this file(y/n)? [y]: ");
                } while (!(delete = InputReader.readInput()).equalsIgnoreCase("y") && !delete.equalsIgnoreCase("n") && delete.trim().length() != 0);
                if (delete.equalsIgnoreCase("y") || delete.trim().length() == 0) {
                    File wso2wsasDir = new File(webappDir.getAbsolutePath() + File.separator + "wso2wsas");
                    if (wso2wsasDir.exists()) {
                        this.fileMan.deleteDir(wso2wsasDir);
                    }
                    warFile.delete();
                    this.fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
                }
            } else {
                this.fileMan.copyFile(new File(InstallerConstants.WSO2WSAS_WAR), warFile);
            }
            System.out.println("OK");
        }
        catch (IOException e) {
            String msg = "Could not copy wso2wsas.war file: " + e;
            System.err.println(" " + msg);
            throw new InstallationException(msg);
        }
    }
}

