/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed.rss;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;

public class ServiceElement {
    public static final int SERVICE_ADD = 0;
    public static final int SERVICE_REMOVE = 1;
    public static final int SERVICE_UPDATE = 2;
    public static final int SERVICE_STOP = 3;
    public static final int SERVICE_START = 4;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
    private String name;
    private String description;
    private List operations;
    private List modules;
    private String url;
    private boolean update;
    private int eventType;
    private boolean rssType;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getOperations() {
        return this.operations;
    }

    public void setOperations(List operations) {
        this.operations = operations;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List getModules() {
        return this.modules;
    }

    public void setModules(List modules) {
        this.modules = modules;
    }

    private OMElement getServiceRemovedRSS(OMFactory fac) {
        OMElement item = fac.createOMElement("item", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText(this.name + " - removed");
        }
        item.addChild((OMNode)title);
        OMElement decriptionElement = fac.createOMElement("description", null);
        decriptionElement.setText("  " + this.name + " : service removed from the system");
        item.addChild((OMNode)decriptionElement);
        OMElement pubDate = fac.createOMElement("pubDate", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(dateFormat.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement guid = fac.createOMElement("guid", null);
        guid.addAttribute("isPermaLink", "false", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement stopService(OMFactory fac) {
        OMElement item = fac.createOMElement("item", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText(this.name + " - deactivated");
        }
        item.addChild((OMNode)title);
        OMElement decriptionElement = fac.createOMElement("description", null);
        decriptionElement.setText("  " + this.name + " : service marked as inactive");
        item.addChild((OMNode)decriptionElement);
        OMElement pubDate = fac.createOMElement("pubDate", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(dateFormat.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement guid = fac.createOMElement("guid", null);
        guid.addAttribute("isPermaLink", "false", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement startService(OMFactory fac) {
        OMElement item = fac.createOMElement("item", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText(this.name + " - activated");
        }
        item.addChild((OMNode)title);
        OMElement decriptionElement = fac.createOMElement("description", null);
        decriptionElement.setText("  " + this.name + ": service marked as active");
        item.addChild((OMNode)decriptionElement);
        OMElement pubDate = fac.createOMElement("pubDate", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(dateFormat.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement guid = fac.createOMElement("guid", null);
        guid.addAttribute("isPermaLink", "false", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement getRSSServiceElement(OMFactory fac) {
        OMElement item = fac.createOMElement("item", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText("  " + this.name + " - updated");
        }
        item.addChild((OMNode)title);
        OMElement epr = fac.createOMElement("link", null);
        epr.setText(this.url + "?info");
        item.addChild((OMNode)epr);
        OMElement decriptionElement = fac.createOMElement("description", null);
        decriptionElement.setText(this.description);
        item.addChild((OMNode)decriptionElement);
        OMElement pubDate = fac.createOMElement("pubDate", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(dateFormat.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement guid = fac.createOMElement("guid", null);
        guid.addAttribute("isPermaLink", "false", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement getServiceRemovedAtom(OMFactory fac) {
        OMElement item = fac.createOMElement("entry", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText("  " + this.name + " - removed");
        }
        OMElement epr = fac.createOMElement("link", null);
        epr.addAttribute("rel", "alternate", null);
        epr.addAttribute("type", "text/html", null);
        epr.addAttribute("href", this.url + "?info", null);
        item.addChild((OMNode)epr);
        item.addChild((OMNode)title);
        OMElement summary = fac.createOMElement("summary", null);
        summary.setText("  " + this.name + " removed from the system");
        item.addChild((OMNode)summary);
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        OMElement pubDate = fac.createOMElement("published", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(zulu.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement modified = fac.createOMElement("updated", null);
        modified.setText(zulu.format(currentTime));
        item.addChild((OMNode)modified);
        OMElement guid = fac.createOMElement("id", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement stopServiceAtom(OMFactory fac) {
        OMElement item = fac.createOMElement("entry", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText(this.name + " - deactivated");
        }
        OMElement epr = fac.createOMElement("link", null);
        epr.addAttribute("rel", "alternate", null);
        epr.addAttribute("type", "text/html", null);
        epr.addAttribute("href", this.url + "?info", null);
        item.addChild((OMNode)epr);
        item.addChild((OMNode)title);
        OMElement summary = fac.createOMElement("summary", null);
        summary.setText("  " + this.name + " : service marked as inactive");
        item.addChild((OMNode)summary);
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        OMElement pubDate = fac.createOMElement("published", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(zulu.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement modified = fac.createOMElement("updated", null);
        modified.setText(zulu.format(currentTime));
        item.addChild((OMNode)modified);
        OMElement guid = fac.createOMElement("id", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement startServiceAtom(OMFactory fac) {
        OMElement item = fac.createOMElement("entry", null);
        OMElement title = fac.createOMElement("title", null);
        if (!this.isUpdate()) {
            title.setText(this.name);
        } else {
            title.setText(this.name + " - activated");
        }
        OMElement epr = fac.createOMElement("link", null);
        epr.addAttribute("rel", "alternate", null);
        epr.addAttribute("type", "text/html", null);
        epr.addAttribute("href", this.url + "?info", null);
        item.addChild((OMNode)epr);
        item.addChild((OMNode)title);
        OMElement summary = fac.createOMElement("summary", null);
        summary.setText("  " + this.name + " : service marked as active");
        item.addChild((OMNode)summary);
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        OMElement pubDate = fac.createOMElement("published", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(zulu.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement modified = fac.createOMElement("updated", null);
        modified.setText(zulu.format(currentTime));
        item.addChild((OMNode)modified);
        OMElement guid = fac.createOMElement("id", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    private OMElement getAtomServiceElement(OMFactory fac) {
        OMElement item = fac.createOMElement("entry", null);
        OMElement title = fac.createOMElement("title", null);
        if (this.eventType == 2) {
            title.setText(this.name + " - updated");
        } else {
            title.setText(this.name);
        }
        item.addChild((OMNode)title);
        OMElement epr = fac.createOMElement("link", null);
        epr.addAttribute("rel", "alternate", null);
        epr.addAttribute("type", "text/html", null);
        epr.addAttribute("href", this.url + "?info", null);
        item.addChild((OMNode)epr);
        OMElement pubDate = fac.createOMElement("published", null);
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(zulu.format(currentTime));
        item.addChild((OMNode)pubDate);
        OMElement modified = fac.createOMElement("updated", null);
        modified.setText(zulu.format(currentTime));
        item.addChild((OMNode)modified);
        OMElement guid = fac.createOMElement("id", null);
        guid.setText(UUIDGenerator.getUUID());
        item.addChild((OMNode)guid);
        return item;
    }

    public OMElement getOMElement(OMFactory fac) {
        if (this.rssType) {
            switch (this.eventType) {
                case 0: {
                    return this.getRSSServiceElement(fac);
                }
                case 1: {
                    return this.getServiceRemovedRSS(fac);
                }
                case 2: {
                    return this.getRSSServiceElement(fac);
                }
                case 4: {
                    return this.startService(fac);
                }
                case 3: {
                    return this.stopService(fac);
                }
            }
        } else {
            switch (this.eventType) {
                case 0: {
                    return this.getAtomServiceElement(fac);
                }
                case 1: {
                    return this.getServiceRemovedAtom(fac);
                }
                case 2: {
                    return this.getAtomServiceElement(fac);
                }
                case 4: {
                    return this.startServiceAtom(fac);
                }
                case 3: {
                    return this.stopServiceAtom(fac);
                }
            }
        }
        return null;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setRssType(boolean rssType) {
        this.rssType = rssType;
    }
}

