/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed.rss;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.feed.FeedFactory;
import org.wso2.wsas.feed.rss.RSSFeed;
import org.wso2.wsas.feed.rss.ServiceElement;

public class RSSFeedBuilder {
    private static Log log = LogFactory.getLog((Class)RSSFeedBuilder.class);
    private RSSFeed rssFeed = FeedFactory.getRSSFeed("wso2wsas.rss");

    public void addService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            ArrayList<String> operations = new ArrayList<String>();
            Iterator ops = serviceDescription.getOperations();
            while (ops.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)ops.next();
                operations.add(axisOperation.getName().getLocalPart());
            }
            serviceElement.setOperations(operations);
            ArrayList<String> modules = new ArrayList<String>();
            Iterator engModIter = serviceDescription.getEngagedModules().iterator();
            while (engModIter.hasNext()) {
                AxisModule axisModule = (AxisModule)engModIter.next();
                modules.add(axisModule.getName());
            }
            serviceElement.setModules(modules);
            serviceElement.setRssType(true);
            serviceElement.setEventType(0);
            this.rssFeed.addRSSElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the add service " + serviceDescription.getName() + " event to the RSS feed"), (Throwable)e);
        }
    }

    public void removeService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setRssType(true);
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setEventType(1);
            this.rssFeed.addRSSElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the remove service " + serviceDescription.getName() + " event to the RSS feed"), (Throwable)e);
        }
    }

    public void stopService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setRssType(true);
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setEventType(3);
            this.rssFeed.addRSSElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the stop service " + serviceDescription.getName() + " event to the RSS feed"), (Throwable)e);
        }
    }

    public void startService(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setRssType(true);
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setEventType(4);
            this.rssFeed.addRSSElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the start service " + serviceDescription.getName() + " event to the RSS feed"), (Throwable)e);
        }
    }

    public void serviceUpdate(AxisService serviceDescription, String itemDefaultLink) {
        try {
            ServiceElement serviceElement = new ServiceElement();
            serviceElement.setDescription(serviceDescription.getDocumentation());
            serviceElement.setName(serviceDescription.getName());
            serviceElement.setUpdate(true);
            ArrayList<String> oprations = new ArrayList<String>();
            Iterator ops = serviceDescription.getOperations();
            while (ops.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)ops.next();
                oprations.add(axisOperation.getName().getLocalPart());
            }
            serviceElement.setOperations(oprations);
            ArrayList<String> modules = new ArrayList<String>();
            Iterator engModIter = serviceDescription.getEngagedModules().iterator();
            while (engModIter.hasNext()) {
                AxisModule axisModule = (AxisModule)engModIter.next();
                modules.add(axisModule.getName());
            }
            serviceElement.setModules(modules);
            serviceElement.setEventType(2);
            serviceElement.setRssType(true);
            this.rssFeed.addRSSElement(serviceElement);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while appending the update service " + serviceDescription.getName() + " event to the RSS feed"), (Throwable)e);
        }
    }
}

