/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.feed.rss;

import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;

public class RSSElement {
    private static Log log = LogFactory.getLog((Class)RSSElement.class);
    private OMElement channelElement;
    private OMElement rssElement;

    public RSSElement(OMFactory fac) {
        this.rssElement = fac.createOMElement("rss", null);
        this.rssElement.addAttribute("version", "2.0", null);
        this.channelElement = fac.createOMElement("channel", null);
        OMElement title = fac.createOMElement("title", null);
        title.setText("WSO2 WSAS RSS");
        this.channelElement.addChild((OMNode)title);
        OMElement link = fac.createOMElement("link", null);
        try {
            String ip = NetworkUtils.getLocalHostname();
            ip = "http://" + ip + ":" + ServerManager.getInstance().getHttpPort();
            link.setText(ip);
        }
        catch (SocketException e) {
            log.warn((Object)"NetworkUtils.getLocalHostname()");
        }
        this.channelElement.addChild((OMNode)link);
        SimpleDateFormat zulu = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
        OMElement description = fac.createOMElement("description", null);
        description.setText("WSO2 WSAS RSS for service publication");
        this.channelElement.addChild((OMNode)description);
        OMElement pubDate = fac.createOMElement("pubDate", null);
        Date currentTime = Calendar.getInstance().getTime();
        pubDate.setText(zulu.format(currentTime));
        this.channelElement.addChild((OMNode)pubDate);
        OMElement lastBuildDate = fac.createOMElement("lastBuildDate", null);
        lastBuildDate.setText(zulu.format(currentTime));
        this.channelElement.addChild((OMNode)lastBuildDate);
        OMElement category = fac.createOMElement("category", null);
        category.setText("WEB SERVICE FEEDS");
        this.channelElement.addChild((OMNode)category);
        OMElement generator = fac.createOMElement("generator", null);
        generator.setText("WSO2 WSAS RSS Feed Generator 1.1");
        this.channelElement.addChild((OMNode)generator);
        OMElement language = fac.createOMElement("language", null);
        language.setText("en-us");
        this.channelElement.addChild((OMNode)language);
        this.rssElement.addChild((OMNode)this.channelElement);
    }

    public OMElement getElement() {
        return this.rssElement;
    }

    public OMElement getChannelElement() {
        return this.channelElement;
    }
}

